/***************************************************************************
 *   Copyright (C) 2003 by Julian Rockey                                   *
 *   linux@jrockey.com                                                     *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/
#ifndef FILECREATE_NEWFILE_H
#define FILECREATE_NEWFILE_H

#include <tqptrlist.h>
#include <tqmap.h>
#include <kurl.h>
#include <kdialogbase.h>

#include "filecreate_filetype.h"

class KURLRequester;
class TQGridLayout;
class KComboBox;
class TQCheckBox;
class KLineEdit;

namespace FileCreate {
  class NewFileChooser : public KDialogBase {
      Q_OBJECT
  public:
    NewFileChooser(TQWidget *parent=0);
    virtual ~NewFileChooser();
    void setFileTypes(TQPtrList<FileType> typelist);
    KURL url() const;
    bool addToProject() const;
    const FileType *selectedType() const;
    void setCurrent(const FileType *filetype);
    void setDirectory(const TQString & url);
    void setName(const TQString & name);
    
    void setInProjectMode(bool m);
  private slots:
      void slotFileNameChanged(const TQString &);
  protected:
    void addType(const FileType * filetype);
	void accept();

    TQGridLayout *m_grid;
    KURLRequester *m_urlreq;
    KComboBox *m_filetypes;
    TQCheckBox *m_addToProject;
    KLineEdit *m_filename;

    TQMap<int,const FileType*> m_typeInCombo;

  };

}

#endif
