/*  This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#ifndef __chm_h__
#define __chm_h__

#include <tqstring.h>
#include <tqcstring.h>
#include <kurl.h>
#include <kio/global.h>
#include <kio/slavebase.h>
#include "chmfile.h"

class TQCString;

class ChmProtocol : public KIO::SlaveBase
{
public:
    ChmProtocol( const TQCString&, const TQCString& );
    ~ChmProtocol();

    void get( const KURL& );

private:
    bool checkNewFile( TQString, TQString& );
    ChmDirectoryMap m_dirMap;
    TQByteArray      m_contents;
    TQString         m_chmFile;
    Chm             m_chm;
};


#endif // __chm_h__

