/***************************************************************************
 *   Copyright (C) 2004 by Alexander Dymo                                  *
 *   cloudtemple@mksat.net                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.             *
 ***************************************************************************/
#ifndef DOCDOXYGENPLUGIN_H
#define DOCDOXYGENPLUGIN_H

#include <kdevdocumentationplugin.h>

class TQDomDocument;
class TQDomElement;

class DocDoxygenPlugin: public DocumentationPlugin
{
    Q_OBJECT
public:
    DocDoxygenPlugin(TQObject* parent, const char* name, const TQStringList args = TQStringList());
    ~DocDoxygenPlugin();

    virtual TQString pluginName() const;

    virtual DocumentationCatalogItem *createCatalog(KListView *contents, const TQString &title, const TQString &url);
    
    virtual void createTOC(DocumentationCatalogItem* item);
    virtual void setCatalogURL(DocumentationCatalogItem* item);

    virtual bool needRefreshIndex(DocumentationCatalogItem* item);
    virtual void createIndex(IndexBox* index, DocumentationCatalogItem* item);

    virtual TQStringList fullTextSearchLocations();
                    
    virtual QPair<KFile::Mode, TQString> catalogLocatorProps();
    virtual TQString catalogTitle(const TQString& url);
    
    virtual void autoSetupPlugin();

    virtual ProjectDocumentationPlugin *projectDocumentationPlugin(ProjectDocType type);
        
protected:
    void createBookTOC(DocumentationItem* item, const TQString &tagUrl = TQString::null, 
        const TQString &baseHtmlUrl = TQString::null);
    void createBookIndex(const TQString &tagfile, IndexBox* index, DocumentationCatalogItem* item, const TQString &baseHtmlUrl = TQString::null);
    
    void createIndexFromTag(TQDomDocument &dom, IndexBox* index, DocumentationCatalogItem* item,
        TQDomElement &parentEl, const TQString &prefix);
    
    void autoSetupDocs(const TQString &defaultDir, const TQString &searchDir, 
        const TQString &name);

    /**
     * Returns all the tag files from a directory and its subdirectories.
     * @param startDir the directory to start with
     * @param level the depth of the current search
     * @return a list with the absolute path to the ".tag" files in startDir
     */
    TQStringList tagFiles(const TQString &startDir, int level = 0);    
};


#endif
