/***************************************************************************
 *   Copyright (C) 2004 by Alexander Dymo                                  *
 *   adymo@mksat.net                                                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.             *
 ***************************************************************************/
#ifndef DOCCUSTOMPLUGIN_H
#define DOCCUSTOMPLUGIN_H

#include <kdevdocumentationplugin.h>

class DocCustomPlugin : public DocumentationPlugin {
public:
    DocCustomPlugin(TQObject* parent, const char* name, const TQStringList args = TQStringList());
    ~DocCustomPlugin();

    virtual TQString pluginName() const;
    
    virtual DocumentationCatalogItem* createCatalog(KListView* contents, const TQString& title, const TQString& url);

    virtual void createTOC(DocumentationCatalogItem* item);
    virtual void setCatalogURL(DocumentationCatalogItem* item);
    
    virtual bool needRefreshIndex(DocumentationCatalogItem* item);
    virtual void createIndex(IndexBox* index, DocumentationCatalogItem* item);

    virtual TQStringList fullTextSearchLocations();
            
    virtual QPair<KFile::Mode, TQString> catalogLocatorProps();
    virtual TQString catalogTitle(const TQString& url);
    
    virtual void autoSetupPlugin();

    virtual ProjectDocumentationPlugin *projectDocumentationPlugin(ProjectDocType type);
};

#endif
