/***************************************************************************
 *   Copyright (C) 2004 by Alexander Dymo                                  *
 *   adymo@mksat.net                                                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.             *
 ***************************************************************************/
#include "doccustomplugin.h"

#include <kurl.h>
#include <kaboutdata.h>
#include <kconfig.h>
#include <klocale.h>
#include <klistview.h>

#include <kdevgenericfactory.h>
#include <kdevplugininfo.h>

static const KDevPluginInfo data("doccustomplugin");
typedef KDevGenericFactory<DocCustomPlugin> DocCustomPluginFactory;
K_EXPORT_COMPONENT_FACTORY( libdoccustomplugin, DocCustomPluginFactory(data) )

DocCustomPlugin::DocCustomPlugin(TQObject* parent, const char* name, const TQStringList // args
                                 )
    :DocumentationPlugin(DocCustomPluginFactory::instance()->config(), parent, name)
{
    setCapabilities(CustomDocumentationTitles | ProjectUserManual);
    autoSetup();
}

DocCustomPlugin::~DocCustomPlugin()
{
}

bool DocCustomPlugin::needRefreshIndex(DocumentationCatalogItem* // item
                                       )
{
    return false;
}

TQString DocCustomPlugin::pluginName() const
{
    return i18n("Custom Documentation Collection");
}

DocumentationCatalogItem* DocCustomPlugin::createCatalog(KListView* contents, const TQString& title, const TQString& url)
{
    DocumentationCatalogItem *item = new DocumentationCatalogItem(this, contents, title);
    item->setURL(KURL(url));
    return item;
}

QPair<KFile::Mode, TQString> DocCustomPlugin::catalogLocatorProps()
{
    return QPair<KFile::Mode, TQString>(KFile::File, "all/allfiles");
}

TQString DocCustomPlugin::catalogTitle(const TQString& /*url*/)
{
    return TQString::null;
}

TQStringList DocCustomPlugin::fullTextSearchLocations()
{
    return TQStringList();
}


void DocCustomPlugin::autoSetupPlugin()
{
    return;
}

void DocCustomPlugin::createIndex(IndexBox* /*index*/, DocumentationCatalogItem* /*item*/)
{
    return;
}

void DocCustomPlugin::createTOC(DocumentationCatalogItem* /*item*/)
{
    return;
}

void DocCustomPlugin::setCatalogURL(DocumentationCatalogItem* /*item*/)
{
    return;
}

ProjectDocumentationPlugin *DocCustomPlugin::projectDocumentationPlugin(ProjectDocType type)
{
    if (type == UserManual)
        return new ProjectDocumentationPlugin(this, type);
    return DocumentationPlugin::projectDocumentationPlugin(type);
}
