/***************************************************************************
 *   Copyright (C) 2004 by Alexander Dymo                                  *
 *   cloudtemple@mksat.net                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.             *
 ***************************************************************************/
#include "docutils.h"

#include <kurlrequester.h>
#include <kurlcompletion.h>
#include <klineedit.h>
#include <kcombobox.h>
#include <kpopupmenu.h>
#include <klocale.h>
#include <kstringhandler.h>

#include <kdevpartcontroller.h>

#include "kdevdocumentationplugin.h"
#include "documentation_part.h"

TQString DocUtils::noEnvURL(const TQString &url)
{
    return KURLCompletion::replacedPath(url, true, true);
}

KURL DocUtils::noEnvURL(const KURL &url)
{
    TQString replaced = KURLCompletion::replacedPath(url.url(), true, true);
    KURL kurl(replaced);
    kurl.setQuery(url.query());
    kurl.setRef(url.ref());
    return kurl;
}

TQString DocUtils::envURL(KURLRequester *req)
{
    if (req->lineEdit())
        return req->lineEdit()->text();
    else if (req->comboBox())
        return req->comboBox()->currentText();
    else
        return req->url();
}

void DocUtils::docItemPopup(DocumentationPart *part, DocumentationItem *docItem,
    const TQPoint &pos, bool showBookmark, bool showSearch, int titleCol)
{
    docItemPopup(part, docItem->text(titleCol), docItem->url(), pos, showBookmark, showSearch);
}

void DocUtils::docItemPopup(DocumentationPart *part, IndexItem *docItem, const TQPoint &pos,
    bool showBookmark, bool showSearch)
{
    //FIXME: index item can have more than one url, what to do?
    KURL url;
    if (docItem->urls().count() > 0)
        url = docItem->urls().first().second;
    docItemPopup(part, docItem->text(), url, pos, showBookmark, showSearch);
}

void DocUtils::docItemPopup(DocumentationPart *part, const TQString &title, const KURL &url,
    const TQPoint &pos, bool showBookmark, bool showSearch)
{
    KPopupMenu menu;
    menu.insertTitle(i18n("Documentation"));
    menu.insertItem(i18n("Open in Current Tab"), 1);
    menu.insertItem(i18n("Open in New Tab"), 2);
    if (showBookmark)
    {
        menu.insertSeparator();   
        menu.insertItem(i18n("Bookmark This Location"), 3);
    }
    if (showSearch)
    {
        menu.insertSeparator();
        menu.insertItem(TQString("%1: %2").arg(i18n("Search")).arg(KStringHandler::csqueeze(title,20)), 4);
    }
    
    switch (menu.exec(pos))
    {
        case 1: part->partController()->showDocument(url); break;
        case 2: part->partController()->showDocument(url, true); break;
        case 3: part->emitBookmarkLocation(title, url); break;
        case 4: part->searchInDocumentation(title); break;
    }
}
