/***************************************************************************
 *   Copyright (C) 2004 by Alexander Dymo                                  *
 *   adymo@mksat.net                                                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.             *
 ***************************************************************************/
#ifndef DOCPROJECTCONFIGWIDGET_H
#define DOCPROJECTCONFIGWIDGET_H

#include "docprojectconfigwidgetbase.h"

class DocumentationPart;
class DocumentationPlugin;

class DocProjectConfigWidget: public DocProjectConfigWidgetBase {
    Q_OBJECT
public:
    DocProjectConfigWidget(DocumentationPart *part, TQWidget *parent = 0, const char *name = 0);

public slots:
    virtual void changeDocSystem(const TQString &text);
    virtual void accept();
    
private:
    DocumentationPart *m_part;
    TQMap<TQString, DocumentationPlugin*> m_plugins;
};
#endif
