/***************************************************************************
 *   Copyright (C) 2004 by Alexander Dymo                                  *
 *   adymo@mksat.net                                                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.             *
 ***************************************************************************/
#ifndef KDEVDOCUMENTATIONIFACE_H
#define KDEVDOCUMENTATIONIFACE_H

#include <tqobject.h>
#include <dcopobject.h>

class DocumentationPart;

class KDevDocumentationIface : public TQObject, public DCOPObject {
    Q_OBJECT
    K_DCOP
public:
    KDevDocumentationIface(DocumentationPart *part);
    ~KDevDocumentationIface();

k_dcop:
    void lookupInIndex(TQString term);
    void findInFinder(TQString term);
    void searchInDocumentation(TQString term);
    void manPage(TQString term);
    void infoPage(TQString term);

    void lookupInIndex();
    void findInFinder();
    void searchInDocumentation();
    void manPage();
    void infoPage();
    
private:
    DocumentationPart *m_part;
};

#endif
