/***************************************************************************
 *   Copyright (C) 2001 by Harald Fernengel                                *
 *   harry@kdevelop.org                                                    *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef _DIFFWIDGET_H_
#define _DIFFWIDGET_H_

#include <tqwidget.h>
#include <tqtextedit.h>
#include <tqstringlist.h>

#include <kurl.h>

class KTempFile;
class DiffPart;

namespace KIO {
  class Job;
}

namespace KParts {
  class ReadOnlyPart;
}

// Helper class that displays a modified RMB popup menu
class KDiffTextEdit: public QTextEdit
{
  Q_OBJECT
public:
  KDiffTextEdit( TQWidget* parent = 0, const char* name = 0 );
  virtual ~KDiffTextEdit();
  void applySyntaxHighlight();
  void clearSyntaxHighlight();

signals:
  void externalPartRequested( const TQString& partName );

protected:
  virtual TQPopupMenu* createPopupMenu( const TQPoint& );
  virtual TQPopupMenu* createPopupMenu();

private slots:
  void popupActivated( int );
  void toggleSyntaxHighlight();
  void saveAs();

private:
  static void searchExtParts();
  static TQStringList extParts;
  static TQStringList extPartsTranslated;
  bool _highlight;
};

class DiffWidget : public QWidget
{
    Q_OBJECT

public:
    DiffWidget( DiffPart * part, TQWidget *parent = 0, const char *name = 0, WFlags f = 0 );
    virtual ~DiffWidget();

public slots:
    /** The URL has to point to a diff file */
    void openURL( const KURL& url );
    /** Pass a diff file in here */
    void setDiff( const TQString& diff );
    /** clears the difference viewer */
    void slotClear();

private slots:
    /** appends a piece of "diff" */
    void slotAppend( const TQString& str );
    /** overloaded for convenience */
    void slotAppend( KIO::Job*, const TQByteArray& ba );
    /** call this when the whole "diff" has been sent.
     *  Don't call slotAppend afterwards!
     */
    void slotFinished();
    void showExtPart();
    void showTextEdit();
    void loadExtPart( const TQString& partName );
    void hideView();

protected:
    void contextMenuEvent( TQContextMenuEvent* e );

private:
    void setExtPartVisible( bool visible );
    void populateExtPart();

private:
    DiffPart * m_part;
    KDiffTextEdit* te;
    KIO::Job* job;
    KParts::ReadOnlyPart* extPart;
    KTempFile* tempFile;
    TQString rawDiff;
};

#endif
