/***************************************************************************
 *   Copyright (C) 2001 by Bernd Gehrmann                                  *
 *   bernd@kdevelop.org                                                    *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef _HIERARCHYDLG_H_
#define _HIERARCHYDLG_H_

#include <tqdialog.h>

#include "codemodel.h"

class ClassViewPart;
class KDevLanguageSupport;
class DigraphView;
class ClassToolWidget;
class KComboView;
class TQListViewItem;

class HierarchyDialog : public QDialog
{
    Q_OBJECT

public:
    HierarchyDialog( ClassViewPart *part );
    ~HierarchyDialog();
public slots:
    void refresh();

private slots:
    void setLanguageSupport(KDevLanguageSupport *ls);
    void slotClassComboChoice(TQListViewItem *item);
    void slotNamespaceComboChoice(TQListViewItem *item);
    void slotClassComboChoice(const TQString&);
    void slotNamespaceComboChoice(const TQString&);
    void classSelected(const TQString &className);
    void save();

private:
    void processNamespace(TQString prefix, NamespaceDom dom);
    void processClass(TQString prefix, ClassDom dom);

    TQMap<TQString, ClassDom> classes;
    //TQMap<class name, fully qualified class name>
    //like MyClass - MyNamespace.MyClass
    TQMap<TQString, TQString> uclasses;

    KComboView *namespace_combo;
    KComboView *class_combo;
    DigraphView *digraph;
//    ClassToolWidget *member_tree;
    ClassViewPart *m_part;
};

#endif
