/***************************************************************************
 *   Copyright (C) 1999 by Jonas Nordin                                    *
 *   jonas.nordin@syncom.se                                                *
 *   Copyright (C) 2000-2001 by Bernd Gehrmann                             *
 *   bernd@kdevelop.org                                                    *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef _CLASSTOOLDLG_H_
#define _CLASSTOOLDLG_H_

#include <tqdialog.h>
#include <tqlabel.h>
#include <tqtoolbutton.h>
#include <tqcombobox.h>
#include <tqlayout.h>
#include "classtoolwidget.h"
#include "parseditem.h"

class ClassViewPart;
class ClassStore;
class ParsedClass;


class ClassToolDialog : public QWidget
{
    Q_OBJECT

public:
    enum Operations { ViewParents, ViewChildren, ViewClients, ViewSuppliers,
                      ViewMethods, ViewAttributes, ViewNone };
    
    ClassToolDialog( ClassViewPart *part );
    ~ClassToolDialog();

    void setClassName(const TQString &name);

public slots:

    /** View nothing. */
    void viewNone();
    /** View the parents of the current class. */
    void viewParents();
    /** View the children of the current class. */
    void viewChildren();
    /** View all classes that has this class as an attribute. */
    void viewClients();
    /** View all classes that this class has as attributes. */
    void viewSuppliers();
    /** View methods in this class and parents. */
    void viewMethods();
    /** View attributes in this class and parents. */
    void viewAttributes();

private slots:
    void setLanguageSupport(KDevLanguageSupport *ls);
    void refresh();

    void delayedClose();
    void slotClose();
    void slotAccessComboChoice(const TQString &str);
    void slotClassComboChoice(const TQString &str);


private:
    void updateCaptionAndButtons();
    void buildTree();

    ClassToolWidget *class_tree;
    TQComboBox *class_combo;
    
    TQToolButton *parents_button;
    TQToolButton *children_button;
    TQToolButton *clients_button;
    TQToolButton *suppliers_button;
    TQToolButton *methods_button;
    TQToolButton *attributes_button;
    TQComboBox *access_combo;
    
    /** Store that holds all classes in the system. */
    ClassStore *m_store;
    KDevLanguageSupport *m_ls;
    ClassViewPart *m_part;
    
    /** The class we are currently viewing. */
    ParsedClass *currentClass;
    /** The current exportstatus selected in the combo. */
    PIAccess comboAccess;
    /** Stores what operation the user selected last. */
    Operations currentOperation;
};

#endif
