/**********************************************************************
**
**
** Definition of QComboView class
**
** Copyright (C) 1992-2000 Trolltech AS.  All rights reserved.
** Copyright (C) 2003 Alexander Dymo <cloudtemple@mksat.net>
**
** This file may be distributed and/or modified under the terms of the
** GNU General Public License version 2 as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL included in the
** packaging of this file.
**
**********************************************************************/

#ifndef QCOMBOVIEW_H
#define QCOMBOVIEW_H

#ifndef QT_H
#include "tqwidget.h"
#endif // QT_H

#ifndef QT_NO_COMBOBOX

/**
@file qcomboview.h
QComboView class.
*/

class TQStrList;
class TQStringList;
class TQLineEdit;
class TQValidator;
class TQListView;
class TQListViewItem;
class QComboViewData;

/**
QComboView - a combo with a TQListView as a popup widget.
This means that you can have a treeview inside of a combo. Otherwise it works
in the same way as TQComboBox and have similar API.
*/
class Q_EXPORT QComboView : public QWidget
{
    Q_OBJECT
    Q_ENUMS( Policy )
    Q_PROPERTY( bool editable READ editable WRITE setEditable )
//    Q_PROPERTY( int count READ count )
    Q_PROPERTY( TQString currentText READ currentText WRITE setCurrentText DESIGNABLE false )
//    Q_PROPERTY( TQListView *currentItem READ currentItem WRITE setCurrentItem )
    Q_PROPERTY( bool autoResize READ autoResize WRITE setAutoResize DESIGNABLE false )
    Q_PROPERTY( int sizeLimit READ sizeLimit WRITE setSizeLimit )
//    Q_PROPERTY( int maxCount READ maxCount WRITE setMaxCount )
    Q_PROPERTY( Policy insertionPolicy READ insertionPolicy WRITE setInsertionPolicy )
    Q_PROPERTY( bool autoCompletion READ autoCompletion WRITE setAutoCompletion )
    Q_PROPERTY( bool duplicatesEnabled READ duplicatesEnabled WRITE setDuplicatesEnabled )
    Q_OVERRIDE( bool autoMask DESIGNABLE true SCRIPTABLE true )

public:
//    QComboView( TQWidget* parent=0, const char* name=0 );
    QComboView( bool rw, TQWidget* parent=0, const char* name=0 );
    ~QComboView();

    int childCount() const;

    TQListViewItem *currentItem() const;
    virtual void setCurrentItem( TQListViewItem * );
    virtual void setCurrentActiveItem( TQListViewItem * );

    bool	autoResize()	const;
    virtual void setAutoResize( bool );
    QSize	sizeHint() const;

    void	setPalette( const TQPalette & );
    void	setFont( const TQFont & );
    void	setEnabled( bool );

    virtual void setSizeLimit( int );
    int		sizeLimit() const;

/*    virtual void setMaxCount( int );
    int		maxCount() const;*/

    enum Policy { NoInsertion, AtTop, AtCurrent, AtBottom,
		  AfterCurrent, BeforeCurrent };

    virtual void setInsertionPolicy( Policy policy );
    Policy	insertionPolicy() const;

    virtual void setValidator( const TQValidator * );
    const TQValidator * validator() const;

    virtual void setListView( TQListView * );
    TQListView *	listView() const;

    virtual void setLineEdit( TQLineEdit *edit );
    TQLineEdit*	lineEdit() const;

    virtual void setAutoCompletion( bool );
    bool	autoCompletion() const;

    bool	eventFilter( TQObject *object, TQEvent *event );

    void	setDuplicatesEnabled( bool enable );
    bool	duplicatesEnabled() const;

    bool	editable() const;
    void	setEditable( bool );

    virtual void popup();

    TQString currentText() const;
    void setCurrentText( const TQString& );

public slots:
    virtual void clear();
    void	clearValidator();
    void	clearEdit();
    virtual void setEditText( const TQString &);

signals:
    void	activated( TQListViewItem * item );
    void	highlighted( TQListViewItem * item );
    void	activated( const TQString &);
    void	highlighted( const TQString &);
    void	textChanged( const TQString &);
    void    focusGranted();
    void    focusLost();

private slots:
    void	internalActivate( TQListViewItem * );
    void	internalHighlight( TQListViewItem * );
    void	internalClickTimeout();
    void	returnPressed();
    void checkState(TQListViewItem*);

protected:
    void	paintEvent( TQPaintEvent * );
    void	resizeEvent( TQResizeEvent * );
    void	mousePressEvent( TQMouseEvent * );
    void	mouseMoveEvent( TQMouseEvent * );
    void	mouseReleaseEvent( TQMouseEvent * );
    void	mouseDoubleClickEvent( TQMouseEvent * );
    void	keyPressEvent( TQKeyEvent *e );
    void	focusInEvent( TQFocusEvent *e );
    void	focusOutEvent( TQFocusEvent *e );
    void	wheelEvent( TQWheelEvent *e );
    void	styleChange( TQStyle& );

    void	updateMask();

private:
    virtual void setUpListView();
    void	setUpLineEdit();
    void	popDownListView();
    void	reIndex();
    void	currentChanged();
    TQListViewItem *completionIndex( const TQString &, TQListViewItem * ) const;

    QComboViewData	*d;

private:	// Disabled copy constructor and operator=
#if defined(Q_DISABLE_COPY)
    QComboView( const QComboView & );
    QComboView &operator=( const QComboView & );
#endif
};


#endif // QT_NO_COMBOBOX

#endif // QCOMBOVIEW_H
