/***************************************************************************
 *   Copyright (C) 2004 by Alexander Dymo                                  *
 *   cloudtemple@mskat.net                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU Library General Public     *
 *   License along with this program; if not, write to the                 *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.             *
 ***************************************************************************/
#include "purledit.h"

#ifndef PURE_QT
#include <kurlrequester.h>
#else
#include <tqpushbutton.h>
#include <tqlineedit.h>
#endif
#include <tqfiledialog.h>
#include <tqlayout.h>

namespace PropertyLib{

PUrlEdit::PUrlEdit(Mode mode, MultiProperty* property, TQWidget* parent, const char* name)
    :PropertyWidget(property, parent, name)
{
    TQHBoxLayout *l = new TQHBoxLayout(this, 0, 0);
#ifndef PURE_QT
    m_edit = new KURLRequester(this);
    l->addWidget(m_edit);
    m_edit->setMode((KFile::Mode)mode);
    connect(m_edit, TQT_SIGNAL(textChanged(const TQString&)), this, TQT_SLOT(updateProperty(const TQString&)));
#else
    m_edit = new KLineEdit(this);
    m_select = new TQPushButton("...",this);
    l->addWidget(m_edit);
    l->addWidget(m_select);
    m_mode = mode;
    connect( m_select, TQT_SIGNAL(clicked()),this,TQT_SLOT(select()));
#endif
    m_edit->setSizePolicy(TQSizePolicy::MinimumExpanding, TQSizePolicy::MinimumExpanding);
}

TQVariant PUrlEdit::value() const
{
#ifndef PURE_QT
     return TQVariant(m_edit->url());
#else
     return TQVariant(m_url);
#endif
}

void PUrlEdit::setValue(const TQVariant& value, bool emitChange)
{
#ifndef PURE_QT
    disconnect(m_edit, TQT_SIGNAL(textChanged(const TQString&)), this, TQT_SLOT(updateProperty(const TQString&)));
    m_edit->setURL(value.toString());
    connect(m_edit, TQT_SIGNAL(textChanged(const TQString&)), this, TQT_SLOT(updateProperty(const TQString&)));
#else
    m_edit->setText(value.toString());
#endif
    if (emitChange)
        emit propertyChanged(m_property, value);
}

void PUrlEdit::updateProperty(const TQString &val)
{
    emit propertyChanged(m_property, TQVariant(val));
}

void PUrlEdit::select()
{
#ifdef PURE_QT
    TQString path = m_url;
    if( m_mode == Directory )
	m_url = TQFileDialog::getExistingDirectory( m_url,this);
    else
        m_url = TQFileDialog::getOpenFileName(m_url, TQString::null, this);
    updateProperty(m_url);
    m_edit->setText(m_url);
#endif
}
	
}

#ifndef PURE_QT
#include "purledit.moc"
#endif
