/***************************************************************************
 *   Copyright (C) 2004 by Alexander Dymo                                  *
 *   cloudtemple@mskat.net                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU Library General Public     *
 *   License along with this program; if not, write to the                 *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.             *
 ***************************************************************************/
#include "psizepolicyedit.h"

#include <klineedit.h>
#include <tqlayout.h>
#include <tqpainter.h>
#include <tqsizepolicy.h>

namespace PropertyLib{

PSizePolicyEdit::PSizePolicyEdit(MultiProperty* property, const TQMap<TQString, TQVariant> &spValues, TQWidget* parent, const char* name)
    :PropertyWidget(property, parent, name), m_spValues(spValues)
{
    TQHBoxLayout *l = new TQHBoxLayout(this, 0, 0);
    m_edit = new KLineEdit(this);
    m_edit->setSizePolicy(TQSizePolicy::MinimumExpanding, TQSizePolicy::MinimumExpanding);
    l->addWidget(m_edit);

    m_edit->setReadOnly(true);
}

TQVariant PSizePolicyEdit::value() const
{
    return m_value;
}

void PSizePolicyEdit::drawViewer(TQPainter* p, const TQColorGroup& cg, const TQRect& r, const TQVariant& value)
{
    p->setPen(Qt::NoPen);
    p->setBrush(cg.background());
    p->drawRect(r);
    p->drawText(r, Qt::AlignLeft | Qt::AlignVCenter | Qt::SingleLine, TQString("%1/%2/%3/%4").arg(findValueDescription(value.toSizePolicy().horData())).arg(findValueDescription(value.toSizePolicy().verData())).arg(value.toSizePolicy().horStretch()).arg(value.toSizePolicy().verStretch()));
}

void PSizePolicyEdit::setValue(const TQVariant& value, bool emitChange)
{
    m_value = value;
    m_edit->setText(TQString("%1/%2/%3/%4").arg(findValueDescription(value.toSizePolicy().horData())).arg(findValueDescription(value.toSizePolicy().verData())).arg(value.toSizePolicy().horStretch()).arg(value.toSizePolicy().verStretch()));

    if (emitChange)
        emit propertyChanged(m_property, value);
}

TQString PSizePolicyEdit::findValueDescription(TQVariant val) const
{
//    qWarning("PSizePolicyEdit::findValueDescription : %d", val.toInt());
    for (TQMap<TQString, TQVariant>::const_iterator it = m_spValues.begin(); it != m_spValues.end(); ++ it)
    {
        if (it.data() == val)
            return it.key();
    }
    return "";
}

}

#ifndef PURE_QT
#include "psizepolicyedit.moc"
#endif
