/***************************************************************************
 *   Copyright (C) 2004 by Alexander Dymo                                  *
 *   cloudtemple@mskat.net                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU Library General Public     *
 *   License along with this program; if not, write to the                 *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.             *
 ***************************************************************************/
#include "pfontbutton.h"

#include <tqlayout.h>
#include <tqpainter.h>
#include <tqpushbutton.h>

#include <kfontrequester.h>

#ifndef PURE_QT
#include <klocale.h>
#else
#include "compat_tools.h"
#endif

namespace PropertyLib{

PFontButton::PFontButton(MultiProperty* property, TQWidget* parent, const char* name)
    :PropertyWidget(property, parent, name)
{
    TQHBoxLayout *l = new TQHBoxLayout(this, 0, 0);
    m_edit = new KFontRequester(this);
    m_edit->setSizePolicy(TQSizePolicy::MinimumExpanding, TQSizePolicy::MinimumExpanding);
#ifndef PURE_QT
    m_edit->button()->setText(i18n("..."));
#endif
    l->addWidget(m_edit);

    connect(m_edit, TQT_SIGNAL(fontSelected(const TQFont& )), this, TQT_SLOT(updateProperty(const TQFont& )));
}

TQVariant PFontButton::value() const
{
    return TQVariant(m_edit->font());
}

void PFontButton::drawViewer(TQPainter* p, const TQColorGroup& cg, const TQRect& r, const TQVariant& value)
{
    p->setPen(Qt::NoPen);
    p->setBrush(cg.background());
    p->drawRect(r);
    TQFontInfo fi(value.toFont());
    p->drawText(r, Qt::AlignLeft | Qt::AlignVCenter | Qt::SingleLine,
        fi.family() + (fi.bold() ? i18n(" Bold") : TQString("")) +
        (fi.italic() ? i18n(" Italic") : TQString("")) +
        " " + TQString("%1").arg(fi.pointSize()) );
}

void PFontButton::setValue(const TQVariant& value, bool emitChange)
{
    disconnect(m_edit, TQT_SIGNAL(fontSelected(const TQFont&)), this, TQT_SLOT(updateProperty(const TQFont&)));
    m_edit->setFont(value.toFont());
    connect(m_edit, TQT_SIGNAL(fontSelected(const TQFont& )), this, TQT_SLOT(updateProperty(const TQFont& )));
    if (emitChange)
        emit propertyChanged(m_property, value);
}

void PFontButton::updateProperty(const TQFont &// font
                                 )
{
    emit propertyChanged(m_property, value());
}

}

#ifndef PURE_QT
#include "pfontbutton.moc"
#endif
