/***************************************************************************
 *   Copyright (C) 2003-2004 by Alexander Dymo                             *
 *   cloudtemple@mskat.net                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU Library General Public     *
 *   License along with this program; if not, write to the                 *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.             *
 ***************************************************************************/
#include "pdoublenuminput.h"

#ifndef PURE_QT
#include <knuminput.h>
#else
#include "qfloatinput.h"
#endif

#include <limits.h>
#include <math.h>
#include <tqlayout.h>

namespace PropertyLib{

PDoubleNumInput::PDoubleNumInput(MultiProperty *property, TQWidget *parent, const char *name)
    :PropertyWidget(property, parent, name)
{
    TQHBoxLayout *l = new TQHBoxLayout(this, 0, 0);
#ifndef PURE_QT
    m_edit = new KDoubleNumInput(-999999.0, 999999.0, 0.0, 0.01, 2, this);
    m_edit->setLabel(TQString::null);
    connect(m_edit, TQT_SIGNAL(valueChanged(double)), this, TQT_SLOT(updateProperty(double)));
#else
    m_edit = new QFloatInput(-999999, 999999, 0.01, 2, this );
    connect(m_edit, TQT_SIGNAL(valueChanged(int)), this, TQT_SLOT(updateProperty(int)));
#endif
    m_edit->setSizePolicy(TQSizePolicy::MinimumExpanding, TQSizePolicy::MinimumExpanding);
/*    m_edit->setMinValue(-999999999);
    m_edit->setMaxValue(+999999999);
    m_edit->setPrecision(2);*/
    l->addWidget(m_edit);

}

TQVariant PDoubleNumInput::value() const
{
    return TQVariant(m_edit->value());
}

void PDoubleNumInput::setValue(const TQVariant &value, bool emitChange)
{
#ifndef PURE_QT
    disconnect(m_edit, TQT_SIGNAL(valueChanged(double)), this, TQT_SLOT(updateProperty(double)));
    m_edit->setValue(value.toDouble());
    connect(m_edit, TQT_SIGNAL(valueChanged(double)), this, TQT_SLOT(updateProperty(double)));
#else
    disconnect(m_edit, TQT_SIGNAL(valueChanged(int)), this, TQT_SLOT(updateProperty(int)));
    m_edit->setValue(int(value.toDouble()*pow(m_edit->digits(),10)));
    connect(m_edit, TQT_SIGNAL(valueChanged(int)), this, TQT_SLOT(updateProperty(int)));
#endif
    if (emitChange)
        emit propertyChanged(m_property, value);
}

void PDoubleNumInput::updateProperty(double val)
{
    emit propertyChanged(m_property, TQVariant(val));
}
void PDoubleNumInput::updateProperty(int val)
{
#ifdef PURE_QT
    TQString format = TQString("%.%1f").arg( m_edit->digits() );
    TQString strVal = TQString().sprintf(format.latin1(),
                                       (val/(float)pow(m_edit->digits(),10)) );
    emit propertyChanged(m_property, TQVariant(strVal));
#else
    Q_UNUSED(val);
#endif
}

}

#ifndef PURE_QT
#include "pdoublenuminput.moc"
#endif
