/* This file is part of the KDE project
   Copyright (C) 2005 Ian Reinhart Geiser <geiseri@kde.org>
   
   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public License
   along with this library; see the file COPYING.LIB.  If not, write to
   the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
   Boston, MA 02110-1301, USA.
*/

#ifndef KDEVPROJECTIFACE_H
#define KDEVPROJECTIFACE_H

#include <dcopobject.h>
#include <tqstringlist.h>
#include <tqmap.h>

class KDevProject;

/**
DCOP Interface for the @ref KDevProject object.

@author KDevelop Authors
*/
class KDevProjectIface : public TQObject, public DCOPObject
{
  Q_OBJECT
      K_DCOP
public:
  KDevProjectIface(KDevProject *prj);

    ~KDevProjectIface();
k_dcop:
    void openProject(const TQString &dirName, const TQString &projectName);
    void closeProject();
    uint options() const;
    TQString projectDirectory() const;
    TQString projectName() const;
    TQString mainProgram() const;
    TQString runDirectory() const;
    TQString activeDirectory() const;
    TQString buildDirectory() const;
    TQStringList allFiles() const;
    TQStringList distFiles() const;
    void addFiles(const TQStringList &fileList);
    void addFile(const TQString &fileName);
    void removeFiles(const TQStringList& fileList);
    void removeFile(const TQString &fileName);
    void changedFiles(const TQStringList &fileList);
    void changedFile(const TQString &fileName);
    bool isProjectFile(const TQString &absFileName);
    TQString relativeProjectFile(const TQString &absFileName);
    TQStringList symlinkProjectFiles();
    
    // Project DOM access
    TQString readEntry(const TQString &path, const TQString &defaultEntry = TQString::null);
    int readIntEntry(const TQString &path, int defaultEntry = 0);
    bool readBoolEntry(const TQString &path, bool defaultEntry = false);
    TQStringList readListEntry(const TQString &path, const TQString &tag);
    TQMap<TQString, TQString> readMapEntry(const TQString &path);
    
    void writeEntry(const TQString &path, const TQString &value);
    void writeIntEntry(const TQString &path, int value);
    void writeBoolEntry( const TQString &path, bool value);
    void writeListEntry(const TQString &path, const TQString &tag, const TQStringList &value);
    void writeMapEntry(const TQString& path, const TQMap<TQString,TQString> &map);
    
  private:
    KDevProject *m_prj;
};

#endif
