/***************************************************************************
 *   Copyright (C) 2003 by Harald Fernengel                                *
 *   harry@kdevelop.org                                                    *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <tqsqldatabase.h>
#include <tqsqlerror.h>
#include <tqsqlcursor.h>
#include <tqsqldriver.h>
#include <tqsqlrecord.h>
#include <tqwidgetstack.h>
#include <tqdatatable.h>
#include <tqtextedit.h>
#include <tqlayout.h>
#include <tqstylesheet.h>

#include <klocale.h>

#include "sqloutputwidget.h"

class QCustomSqlCursor: public QSqlCursor
{
public:
    QCustomSqlCursor( const TQString & query = TQString::null, bool autopopulate = TRUE, TQSqlDatabase* db = 0 ) :
                TQSqlCursor( TQString::null, autopopulate, db )
    {
        exec( query );
        if ( isSelect() && autopopulate ) {
            TQSqlRecordInfo inf = ((TQSqlQuery*)this)->driver()->recordInfo( *(TQSqlQuery*)this );
            for ( TQSqlRecordInfo::iterator it = inf.begin(); it != inf.end(); ++it ) {
                append( *it );
            }
        }
        setMode( TQSqlCursor::ReadOnly );
    }
    QCustomSqlCursor( const QCustomSqlCursor & other ): TQSqlCursor( other ) {}
    bool select( const TQString & /*filter*/, const TQSqlIndex & /*sort*/ = TQSqlIndex() )
        { return exec( lastQuery() ); }
    TQSqlIndex primaryIndex( bool /*prime*/ = TRUE ) const
        { return TQSqlIndex(); }
    int insert( bool /*invalidate*/ = TRUE )
        { return FALSE; }
    int update( bool /*invalidate*/ = TRUE )
        { return FALSE; }
    int del( bool /*invalidate*/ = TRUE )
        { return FALSE; }
    void setName( const TQString& /*name*/, bool /*autopopulate*/ = TRUE ) {}
};


SqlOutputWidget::SqlOutputWidget ( TQWidget* parent, const char* name ) :
    TQWidget( parent, name )
{
    m_stack = new TQWidgetStack( this );
    m_table = new TQDataTable( this );
    m_textEdit = new TQTextEdit( this );

    m_textEdit->setTextFormat( TQTextEdit::RichText );
    m_textEdit->setReadOnly( true );
    
    m_stack->addWidget( m_textEdit );
    m_stack->addWidget( m_table );

    TQVBoxLayout* layout = new TQVBoxLayout( this );
    layout->addWidget( m_stack );
}

SqlOutputWidget::~SqlOutputWidget()
{}

void SqlOutputWidget::showQuery( const TQString& connectionName, const TQString& query )
{
    TQSqlDatabase* db = TQSqlDatabase::database( connectionName, true );
    if ( !db ) {
        showError( i18n("No such connection: %1").arg( connectionName ) );
        return;
    }
    if ( !db->isOpen() ) {
        showError( db->lastError() );
        return;
    }

    TQSqlCursor* cur = new QCustomSqlCursor( query, true, db );
    if ( !cur->isActive() ) {
        showError( cur->lastError() );
    } else if ( cur->isSelect() ) {
        m_table->setSqlCursor( cur, true, true );
        m_table->refresh( TQDataTable::RefreshAll );
        m_stack->raiseWidget( m_table );
    } else {
        showSuccess( cur->numRowsAffected() );
    }
}

void SqlOutputWidget::showSuccess( int rowsAffected )
{
    m_textEdit->clear();
    m_textEdit->setText( i18n("Query successful, number of rows affected: %1").arg( rowsAffected ) );
    m_stack->raiseWidget( m_textEdit );
}

void SqlOutputWidget::showError( const TQString& message )
{
    m_textEdit->clear();
    m_textEdit->setText( "<p><b>" + i18n("An error occurred:") + "</b></p>\n" + message );
    m_stack->raiseWidget( m_textEdit );
}

void SqlOutputWidget::showError( const TQSqlError& message )
{
    m_textEdit->clear();
    m_textEdit->setText( "<p><b>" + i18n("An error occurred:") + 
                         "</b></p>\n<p><i>" + i18n("Driver") + "</i>: " + 
                         TQStyleSheet::escape( message.driverText() ) + 
                         "<br><i>" + i18n("Database") + ":</i>: " +
                         TQStyleSheet::escape( message.databaseText() ) );
    m_stack->raiseWidget( m_textEdit );
}

#include "sqloutputwidget.moc"

