/***************************************************************************
 *   Copyright (C) 2001-2002 by Bernd Gehrmann                             *
 *   bernd@kdevelop.org                                                    *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef _PYTHONSUPPORTPART_H_
#define _PYTHONSUPPORTPART_H_


#include "kdevlanguagesupport.h"

class KDialogBase;
class TQStringList;
class TQPopupMenu;
class Context;

class PythonSupportPart : public KDevLanguageSupport
{
    Q_OBJECT

public:
    PythonSupportPart( TQObject *parent, const char *name, const TQStringList & );
    ~PythonSupportPart();
  
    virtual KDevDesignerIntegration *designer(KInterfaceDesigner::DesignerType type);
    
public slots:
    void contextMenu(TQPopupMenu *popup, const Context *context);
    void slotCreateSubclass();

protected:
    virtual Features features();
    virtual KMimeType::List mimeTypes();
    
private slots:
    void projectConfigWidget(KDialogBase *dlg);
    void projectOpened();
    void projectClosed();
    void savedFile(const KURL &fileName);
    void addedFilesToProject(const TQStringList &fileList);
    void removedFilesFromProject(const TQStringList &fileList);
    void slotExecute();
    void slotExecuteString();
    void slotStartInterpreter();
    
    // Internal
    void initialParse();
    void slotPydoc();
    
private:
    TQString interpreter();
    void startApplication(const TQString &program);
    void maybeParse(const TQString fileName);
    void parse(const TQString &fileName);

    TQMap<KInterfaceDesigner::DesignerType, KDevDesignerIntegration*> m_designers;
    TQString m_contextFileName;
};

#endif
