/*
   Copyright (C) 2005 by Nicolas Escuder <n.escuder@intra-links.com>

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   version 2, License as published by the Free Software Foundation.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public License
   along with this library; see the file COPYING.LIB.  If not, write to
   the Free Software Foundation, Inc., 51 Franklin Steet, Fifth Floor,
   Boston, MA 02110-1301, USA.
*/

#ifndef PHPPARSER_H
#define PHPPARSER_H

#include <tqthread.h>

#if QT_VERSION < 0x030100
#include <kdevmutex.h>
#else
#include <tqmutex.h>
#endif

#include <codemodel.h>

#include <tqwaitcondition.h>
#include <tqstring.h>
#include <tqstringlist.h>

#include "phpfile.h"

class KDevCore;
class PHPSupportPart;

/**
  *@author Sandy Meier
  */

class PHPParser: public TQThread {

public:
   PHPParser(PHPSupportPart *part);
   ~PHPParser();

   void addFile( const TQString& fileName );
   bool hasFile( const TQString& fileName );
   void reparseFile( const TQString& fileName );
   void removeFile( const TQString& fileName );
   void removeAllFiles();

   void run();
   void close();
   void startParse();

private:
   CodeModel* m_model;
   KDevCore* m_core;
   PHPSupportPart* m_part;

   TQMutex m_mutex;
   TQWaitCondition m_canParse;
   bool m_close;
   TQMap<TQString, PHPFile*> m_files;
};


#endif
