/*
   Copyright (C) 2002 by Roberto Raggi <roberto@kdevelop.org>
   Copyright (C) 2005 by Nicolas Escuder <n.escuder@intra-links.com>

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   version 2, License as published by the Free Software Foundation.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public License
   along with this library; see the file COPYING.LIB.  If not, write to
   the Free Software Foundation, Inc., 51 Franklin Steet, Fifth Floor,
   Boston, MA 02110-1301, USA.
*/

#ifndef PHPERRORVIEW_H
#define PHPERRORVIEW_H

#include <klistview.h>
#include <klineedit.h>
#include <tqguardedptr.h>
#include "phpfile.h"

class PHPSupportPart;
class TQTimer;
class TQTabBar;
class TQWidgetStack;
class TQGridLayout;
class KDialogBase;
class Problem;
class KURL;

namespace KParts{
    class Part;
}

namespace KTextEditor{
    class MarkInterface;
    class Document;
}


enum Errors
{
   Error = 0,
   ErrorParse = 1,
   ErrorNoSuchFunction = 2,
   Warning = 3,
   Todo = 4,
   Fixme = 5
};

class PHPErrorView: public TQWidget {
Q_OBJECT
public:
   PHPErrorView( PHPSupportPart* part, TQWidget* parent=0, const char* name=0 );
   virtual ~PHPErrorView();

   void removeAllProblems( const TQString& filename );
   void reportProblem( int level,  const TQString& fileName, int line, const TQString& text);

private slots:
   void slotPartAdded( KParts::Part* );
   void slotPartRemoved( KParts::Part* );
   void slotActivePartChanged( KParts::Part* );
   void slotSelected( TQListViewItem* );
   void slotTabSelected( int tabindex );
   void slotFilter();

private:
   TQString levelToString( int level ) const;
   int levelToMarkType( int level ) const;
   void InitListView(KListView* listview);
   void removeAllItems( TQListView* listview, const TQString& filename );
   void filterList(KListView* listview, const TQString& level);
   void updateCurrentWith(TQListView* listview, const TQString& level, const TQString& filename);
   void initCurrentList();

private:
   TQGridLayout* m_gridLayout;
   TQTabBar* m_tabBar;
   TQWidgetStack* m_widgetStack;
   KListView* m_currentList;
   KListView* m_errorList;
   KListView* m_fixmeList;
   KListView* m_warningList;
   KListView* m_todoList;
   KListView* m_filteredList;
   KLineEdit* m_filterEdit;

   PHPSupportPart* m_phpSupport;
   TQGuardedPtr<KTextEditor::Document> m_document;
   KTextEditor::MarkInterface* m_markIface;
   TQTimer* m_timer;
   TQString m_fileName;
   int m_active;
   int m_delay;
};

#endif
