/***************************************************************************
 *   Copyright (C) 2003 by Alexander Dymo                                  *
 *   cloudtemple@mksat.net                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/
#ifndef OPTIONTABS_H
#define OPTIONTABS_H

#include <tqwidget.h>

class FlagRadioButtonController;
class FlagPathEditController;
class FlagCheckBoxController;
class FlagEditController;
class TQRadioButton;
class FlagRadioButton;
class FlagCheckBox;

class LinkerTab : public QWidget
{
public:
    LinkerTab( TQWidget *parent=0, const char *name=0 );
    ~LinkerTab();

    void readFlags(TQStringList *str);
    void writeFlags(TQStringList *str);

private:
    FlagRadioButtonController *radioController;
    FlagPathEditController *pathController;
    FlagEditController *editController;
};

class LocationsTab : public QWidget
{
public:
    LocationsTab( TQWidget *parent=0, const char *name=0 );
    ~LocationsTab();

    void readFlags(TQStringList *str);
    void writeFlags(TQStringList *str);

private:
    FlagPathEditController *pathController;
};

class Locations2Tab : public QWidget
{
public:
    Locations2Tab( TQWidget *parent=0, const char *name=0 );
    ~Locations2Tab();

    void readFlags(TQStringList *str);
    void writeFlags(TQStringList *str);

private:
    FlagPathEditController *pathController;
};

class GeneralTab: public QWidget
{
public:
    GeneralTab( TQWidget *parent=0, const char *name=0 );
    ~GeneralTab();

    void readFlags(TQStringList *str);
    void writeFlags(TQStringList *str);

private:
    FlagCheckBoxController *controller;
    FlagEditController *editController;
};

class CodegenTab : public QWidget
{
public:
    CodegenTab( TQWidget *parent=0, const char *name=0 );
    ~CodegenTab();

    void readFlags(TQStringList *str);
    void writeFlags(TQStringList *str);

private:
    FlagCheckBoxController *controller;
    FlagEditController *listController;
    FlagRadioButtonController *radioController;
};

class DebugOptimTab : public QWidget
{
    Q_OBJECT
public:
    DebugOptimTab( TQWidget *parent=0, const char *name=0 );
    ~DebugOptimTab();

    void readFlags(TQStringList *str);
    void writeFlags(TQStringList *str);

private:
    FlagCheckBoxController *controller;
    FlagRadioButtonController *radioController;

    FlagCheckBox *gdb;
    FlagCheckBox *namespacedb;
    FlagCheckBox *symboldb;

private slots:
    void setReleaseOptions();
    void setDebugOptions();
};

#endif
