/***************************************************************************
 *   Copyright (C) 2003 by Roberto Raggi                                   *
 *   roberto@kdevelop.org                                                  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef __javasupport_events_h
#define __javasupport_events_h

#include "driver.h"
#include "kdevdeepcopy.h"

#include <tqevent.h>
#include <tqvaluelist.h>

#if QT_VERSION < 0x030100
#include <kdevmutex.h>
#else
#include <tqmutex.h>
#endif

enum
{
    Event_FileParsed = TQEvent::User + 1000
};

class FileParsedEvent: public QCustomEvent
{
public:
    FileParsedEvent( const TQString& fileName, const TQValueList<Problem>& problems )
    : TQCustomEvent(Event_FileParsed), m_fileName( deepCopy(fileName) )
    {
        // the members are deep copies
        TQValueListConstIterator<Problem> it = problems.begin();
        while (it != problems.end()) {
            Problem p = *it;
            m_problems.append(Problem(deepCopy(p.text()), p.line(), p.column(), p.level()));
            ++it;
        }
    }

    TQString fileName() const { return m_fileName; }
    TQValueList<Problem> problems() const { return m_problems; }

private:
    TQString m_fileName;
    TQValueList<Problem> m_problems;

private:
    FileParsedEvent( const FileParsedEvent& source );
    void operator = ( const FileParsedEvent& source );
};


#endif // __javasupport_events_h
