/***************************************************************************
 *   Copyright (C) 2002 by Roberto Raggi                                   *
 *   roberto@kdevelop.org                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef BACKGROUNDPARSER_H
#define BACKGROUNDPARSER_H

#include "driver.h"
#include "JavaAST.hpp"

#include <tqthread.h>
#include <tqwaitcondition.h>
#include <tqmutex.h>
#include <tqmap.h>
#include <kdebug.h>

class JavaSupportPart;
class TranslationUnitAST;
class SynchronizedFileList;

class Unit
{
public:
    Unit() {}
    ~Unit() {}

    TQString fileName;
    TQValueList<Problem> problems;
    RefJavaAST translationUnit;

protected:
    Unit( const Unit& source );
    void operator = ( const Unit& source );
};

class BackgroundParser: public QThread
{
public:
    BackgroundParser( JavaSupportPart*, TQWaitCondition* consumed );
    virtual ~BackgroundParser();

    TQMutex& mutex() { return m_mutex; }
    void lock() { m_mutex.lock(); }
    void unlock() { m_mutex.unlock(); }

    TQWaitCondition& canParse() { return m_canParse; }
    TQWaitCondition& isEmpty() { return m_isEmpty; }

    bool filesInQueue();

    void addFile( const TQString& fileName, bool readFromDisk=false );
    void removeFile( const TQString& fileName );
    void removeAllFiles();

    RefJavaAST translationUnit( const TQString& fileName );
    TQValueList<Problem> problems( const TQString& fileName );

    void close();

    virtual void run();

protected:
    Unit* findUnit( const TQString& fileName );
    Unit* parseFile( const TQString& fileName, bool readFromDisk );

private:
    class KDevDriver* m_driver;
    TQString m_currentFile;
    TQWaitCondition m_canParse;
    TQWaitCondition m_isEmpty;
    TQWaitCondition* m_consumed;
    TQMutex m_mutex;
    SynchronizedFileList* m_fileList;
    JavaSupportPart* m_javaSupport;
    bool m_close;
    TQMap<TQString, Unit*> m_unitDict;
};

#endif
