
/***************************************************************************
   copyright            : (C) 2006 by David Nolden
   email                : david.nolden.kdevelop@art-master.de
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef __STRINGHELPERS_H__
#define __STRINGHELPERS_H__


#include "completiondebug.h"
#include "codeinformationrepository.h"


namespace StringHelpers {

void clearStr( TQString& str, int start, int end );

///Fills all comments with whitespaces
TQString clearComments( TQString str );

TQString cutTemplateParams( TQString str );

QPair<TQString, TQString> splitTemplateParams( TQString str );

bool parenFits( TQChar c1, TQChar c2 );

bool isParen( TQChar c1 );

bool isTypeParen( TQChar c1 );

bool isTypeOpenParen( TQChar c1 );

bool isTypeCloseParen( TQChar c1 );

bool isLeftParen( TQChar c1 );

/*only from left to right
searches a fitting closing sign ( a ')' for a '(', ']' for '['
ignores quoted text
comments are currently not allowed */
int findClose( const TQString& str , int pos ); //todo: make this respect strings

TQString tagType( const Tag& tag );

int findCommaOrEnd( const TQString& str , int pos, TQChar validEnd = ' ' );

int countExtract( TQChar c, const TQString& str );

TQString templateParamFromString( int num, TQString str );

TQStringList splitType( TQString str ) ;

class ParamIterator {
  public:
    ParamIterator( TQString parens, TQString source ) : m_source( source ), m_parens( parens ), m_cur( 0 ), m_curEnd ( 0 ) {
      int begin = m_source.find( m_parens[ 0 ] );
      int end = m_source.findRev( m_parens[ 1 ] );
	    m_prefix = m_source.left( begin );
	    
      if ( begin == -1 || end == -1 && end - begin > 1 )
        m_cur = m_source.length();
      else {
        m_source = source.mid( begin + 1, end - begin );
        m_curEnd = next();
      }
    }

    ParamIterator& operator ++() {
      m_cur = m_curEnd + 1;
      if ( m_cur < ( int ) m_source.length() ) {
        m_curEnd = next();
      }
      return *this;
    }

    TQString operator *() {
      return m_source.mid( m_cur, m_curEnd - m_cur ).stripWhiteSpace();
    }

    operator bool() const {
      return m_cur < ( int ) m_source.length();
    }

    TQString prefix() const {
	    return m_prefix;
    }

  private:
		TQString m_prefix;
    TQString m_source;
    TQString m_parens;
    int m_cur;
    int m_curEnd;

    int next() {
      return findCommaOrEnd( m_source, m_cur, m_parens[ 1 ] );
    }

};

bool isValidIdentifierSign( const TQChar& c );

TQString stringMult( int count, TQString str );
}


#endif 
// kate: tab-width 2;
