/***************************************************************************
 *   Copyright (C) 2003 by Roberto Raggi                                   *
 *   roberto@kdevelop.org                                                  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KDEVQTIMPORTER_H
#define KDEVQTIMPORTER_H

#include <kdevpcsimporter.h>
#include <tqguardedptr.h>

class SettingsDialog;

class KDevQtImporter : public KDevPCSImporter
{
    Q_OBJECT
public:
    KDevQtImporter( TQObject* parent=0, const char* name=0, const TQStringList& args=TQStringList() );
    virtual ~KDevQtImporter();

    virtual TQString dbName() const { return TQString::fromLatin1("Qt"); }
    virtual TQStringList fileList();
    virtual TQStringList includePaths();

    virtual TQWidget* createSettingsPage( TQWidget* parent, const char* name=0 );

private:
    TQGuardedPtr<SettingsDialog> m_settings;
};

#endif
