/***************************************************************************
 *   Copyright (C) 2003 by Roberto Raggi                                   *
 *   roberto@kdevelop.org                                                  *
 *                                                                         *
 *   Copyright (C) 2006 by Jens Dagerbo                                    *
 *   jens.dagerbo@swipnet.se                                               *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <klistbox.h>
#include <kcombobox.h>
#include <kurlrequester.h>
#include <kdebug.h>
#include <klineedit.h>
#include <kmessagebox.h>
#include <klocale.h>

#include <tqfile.h>
#include <tqdir.h>
#include <tqregexp.h>
#include <cstdlib>

#include "settingsdialog.h"

TQListBoxItem* QListBox_selectedItem(TQListBox* cpQListBox)
{
    if ( cpQListBox->selectionMode() != TQListBox::Single )
    return 0;
    if ( cpQListBox->isSelected( cpQListBox->currentItem() ) )
    return  cpQListBox->item(cpQListBox->currentItem());
    return 0;
}

SettingsDialog::SettingsDialog(TQWidget* parent, const char* name, WFlags fl)
    : SettingsDialogBase(parent,name,fl)
{
    TQStringList qtdirs;
	qtdirs.push_back( ::getenv("QTDIR") + TQString("/include") );
	qtdirs.push_back( TQString::fromLocal8Bit(::getenv("HOME")) + "/dev/qt/include" );
	qtdirs.push_back( TQString::fromLocal8Bit(::getenv("HOME")) + "/dev/qt-main/include" );
	qtdirs.push_back( "/usr/qt/4/include" );

    for( TQStringList::Iterator it=qtdirs.begin(); it!=qtdirs.end(); ++it )
    {
        TQString qtdir = *it;
        if( !qtdir.isEmpty() && isValidQtDir(qtdir) )
            if (!qtListBox->findItem(qtdir, ExactMatch))
                qtListBox->insertItem( qtdir );
    }

	qtUrl->setMode( KFile::Directory | KFile::ExistingOnly | KFile::LocalOnly );

	connect( addUrlButton, TQT_SIGNAL(clicked()), this, TQT_SLOT(addUrlButton_clicked()) );
}

SettingsDialog::~SettingsDialog()
{
}

void SettingsDialog::slotSelectionChanged(TQListBoxItem* item)
{
    if( !qtListBox->selectedItem() )
	{
        emit enabled( false );
        return;
    }


    emit enabled( true );
}

bool SettingsDialog::isValidQtDir( const TQString & path ) const
{
    return TQFile::exists( path + "/QtCore/QtCore" );
}

TQString SettingsDialog::qtDir( ) const
{
    return qtListBox->currentText();
}

TQString SettingsDialog::configuration( ) const
{
    return "";
}

void SettingsDialog::addUrlButton_clicked( )
{
	kdDebug(9000) << k_funcinfo << endl;

	if ( isValidQtDir( qtUrl->url() ) )
	{
		qtListBox->insertItem( qtUrl->url() );
		if ( TQListBoxItem * item = qtListBox->findItem( qtUrl->url(), ExactMatch ) )
		{
			qtListBox->setSelected( item, true );
		}
		qtUrl->lineEdit()->clear();
	}
	else
	{
		KMessageBox::error( this, i18n("This does not appear to be a valid Qt4 include directory.\nPlease select a different directory."), i18n("Invalid Directory") );
	}
}


#include "settingsdialog.moc"
//kate: indent-mode csands; tab-width 4; space-indent off;


