/***************************************************************************
*   Copyright (C) 2003 by Alexander Dymo                                  *
*   cloudtemple@mksat.net                                                 *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
***************************************************************************/
#ifndef KDEVCUSTOMIMPORTER_H
#define KDEVCUSTOMIMPORTER_H

#include "kdevpcsimporter.h"

#include <tqguardedptr.h>

class SettingsDialog;

class KDevCustomImporter : public KDevPCSImporter
{
Q_OBJECT
public:
    KDevCustomImporter(TQObject* parent = 0, const char* name = 0, const TQStringList &args = TQStringList());

    ~KDevCustomImporter();

    virtual TQString dbName() const;
    virtual TQStringList fileList();
    virtual TQStringList includePaths();
    virtual TQWidget* createSettingsPage(TQWidget* parent, const char* name);

protected:
    TQStringList fileList( const TQString& path );
    void processDir(const TQString path, TQStringList &files );

private:
    TQGuardedPtr<SettingsDialog> m_settings;
};

#endif
