/***************************************************************************
*   Copyright (C) 2003 by Alexander Dymo                                  *
*   cloudtemple@mksat.net                                                 *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
*                                                                         *
***************************************************************************/

#ifndef CLASSGENERATORCONFIG_H
#define CLASSGENERATORCONFIG_H

#include "classgeneratorconfigbase.h"

class ClassGeneratorConfig : public ClassGeneratorConfigBase
{
	Q_OBJECT

public:
	enum NameCase { LowerCase, UpperCase, SameAsClassCase, SameAsFileCase };

	ClassGeneratorConfig( TQWidget* parent = 0, const char* name = 0, WFlags fl = 0 );

	ClassGeneratorConfig( TQString v_cppHeaderText, TQString v_cppSourceText,
	                      TQString v_objcHeaderText, TQString v_objcSourceText,
	                      TQString v_gtkHeaderText, TQString v_gtkSourceText,
	                      NameCase v_fileCase, NameCase v_defCase, NameCase v_superCase,
	                      bool v_showAuthor, bool v_genDoc, bool v_reformat,
	                      TQWidget* parent = 0, const char* name = 0, WFlags fl = 0 );

	~ClassGeneratorConfig();
	/*$PUBLIC_FUNCTIONS$*/

	void readConfig();

	TQString cppHeader();
	TQString cppSource();
	TQString objcHeader();
	TQString objcSource();
	TQString gtkHeader();
	TQString gtkSource();

	NameCase fileCase();
	NameCase defCase();
	NameCase superCase();

	bool showAuthor();
	bool genDoc();

public slots:
	/*$PUBLIC_SLOTS$*/
	void storeConfig();

protected:
	/*$PROTECTED_FUNCTIONS$*/

protected slots:
	/*$PROTECTED_SLOTS$*/
	virtual void templateTypeChanged( int type );

private:
	TQString *identifyTemplate( int value );
	TQString templateText( TQString path );
	void saveTemplateText( TQString path, TQString content );

	TQString cppHeaderText;
	TQString cppSourceText;
	TQString objcHeaderText;
	TQString objcSourceText;
	TQString gtkHeaderText;
	TQString gtkSourceText;

	TQString *currTemplate;
};

#endif 
// kate: indent-mode csands; tab-width 4;


