%{H_TEMPLATE}

#ifndef %{APPNAMEUC}_H
#define %{APPNAMEUC}_H

#include <TQMainWindow>
#include <TQCloseEvent>

class TQAction;
class QMenu;
class TQTextEdit;

class %{APPNAME}:public QMainWindow
{
      Q_OBJECT

public:
      %{APPNAME}();
      ~%{APPNAME}();

protected:
      void closeEvent(TQCloseEvent *event);

private slots:
      void newFile();
      void open();
      bool save();
      bool saveAs();
      void about();
      void documentWasModified();

private:
      void createActions();
      void createMenus();
      void createToolBars();
      void createStatusBar();
      void readSettings();
      void writeSettings();
      bool maybeSave();
      void loadFile(const TQString &fileName);
      bool saveFile(const TQString &fileName);
      void setCurrentFile(const TQString &fileName);
      TQString strippedName(const TQString &fullFileName);

      TQTextEdit *textEdit;
      TQString curFile;

      QMenu *fileMenu;
      QMenu *editMenu;
      QMenu *helpMenu;
      TQToolBar *fileToolBar;
      TQToolBar *editToolBar;
      TQAction *newAct;
      TQAction *openAct;
      TQAction *saveAct;
      TQAction *saveAsAct;
      TQAction *exitAct;
      TQAction *cutAct;
      TQAction *copyAct;
      TQAction *pasteAct;
      TQAction *aboutAct;
      TQAction *aboutQtAct;
};

#endif
