//
#ifndef __ADASUPPORTPART_H__
#define __ADASUPPORTPART_H__

#include "kdevlanguagesupport.h"

#include <tqwaitcondition.h>

class AdaSupportPartData;
class KDialogBase;
class TQStringList;

class AdaSupportPart : public KDevLanguageSupport
{
    Q_OBJECT
public:
    AdaSupportPart (TQObject *parent, const char *name, const TQStringList &);
    ~AdaSupportPart ();

    void parseContents (const TQString& contents, const TQString& fileName);

protected:
    Features features ();
    KMimeType::List mimeTypes ();
    TQStringList fileExtensions ();

private slots:
    void projectOpened ();
    void projectClosed ();

    void addedFilesToProject (const TQStringList &fileList);
    void removedFilesFromProject (const TQStringList &fileList);
    void changedFilesInProject( const TQStringList &fileList );

    void initialParse ();
    void savedFile (const KURL&);

private:
    void maybeParse (const TQString &fileName);
    void parse (const TQString &fileName);

    void saveProjectSourceInfo( );
private:
    AdaSupportPartData* d;
    
friend class ProblemReporter;
};


#endif
