/**********************************************************************
** Copyright (C) 2000 Trolltech AS.  All rights reserved.
**
** This file is part of Qt Designer.
**
** This file may be distributed and/or modified under the terms of the
** GNU General Public License version 2 as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL included in the
** packaging of this file.
**
** Licensees holding valid Qt Enterprise Edition or Qt Professional Edition
** licenses may use this file in accordance with the Qt Commercial License
** Agreement provided with the Software.
**
** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
**
** See http://www.trolltech.com/gpl/ for GPL licensing information.
** See http://www.trolltech.com/pricing.html or email sales@trolltech.com for
**   information about Qt Commercial License Agreements.
**
** Contact info@trolltech.com if any conditions of this licensing are
** not clear to you.
**
**********************************************************************/

#ifndef QWIDGETFACTORY_H
#define QWIDGETFACTORY_H

#ifndef QT_H
#include <tqstring.h>
#include <tqptrlist.h>
#include <tqimage.h>
#include <tqpixmap.h>
#include <tqvaluelist.h>
#include <tqmap.h>
#include <tqaction.h>
#endif // QT_H

class TQDomDocument;
class TQDomElement;
class TQLayout;
class TQListView;
class TQListViewItem;
class TQMenuBar;
class TQTable;
class TQWidget;
class QWidgetFactoryPrivate;
class UibStrTable;

class QWidgetFactory
{
public:
    TQWidgetFactory();
    virtual ~TQWidgetFactory();

    static TQWidget *create( const TQString &uiFile, TQObject *connector = 0, TQWidget *parent = 0, const char *name = 0 );
    static TQWidget *create( TQIODevice *dev, TQObject *connector = 0, TQWidget *parent = 0, const char *name = 0 );
    static void addWidgetFactory( TQWidgetFactory *factory );
    static void loadImages( const TQString &dir );

    virtual TQWidget *createWidget( const TQString &className, TQWidget *parent, const char *name ) const;
    static TQStringList widgets();
    static bool supportsWidget( const TQString &widget );

private:
    enum LayoutType { HBox, VBox, Grid, NoLayout };
    void loadImageCollection( const TQDomElement &e );
    void loadConnections( const TQDomElement &e, TQObject *connector );
    void loadTabOrder( const TQDomElement &e );
    TQWidget *createWidgetInternal( const TQDomElement &e, TQWidget *parent, TQLayout* layout, const TQString &classNameArg );
    TQLayout *createLayout( TQWidget *widget, TQLayout*  layout, LayoutType type, bool isQLayoutWidget = FALSE );
    LayoutType layoutType( TQLayout *l ) const;
    void setProperty( TQObject* widget, const TQString &prop, TQVariant value );
    void setProperty( TQObject* widget, const TQString &prop, const TQDomElement &e );
    void createSpacer( const TQDomElement &e, TQLayout *layout );
    TQImage loadFromCollection( const TQString &name );
    TQPixmap loadPixmap( const TQString &name );
    TQPixmap loadPixmap( const TQDomElement &e );
    TQColorGroup loadColorGroup( const TQDomElement &e );
    void createListViewColumn( TQListView *lv, const TQString& txt,
			       const TQPixmap& pix, bool clickable,
			       bool resizable );
#ifndef QT_NO_TABLE
    void createTableColumnOrRow( TQTable *table, const TQString& txt,
				 const TQPixmap& pix, const TQString& field,
				 bool isRow );
#endif
    void createColumn( const TQDomElement &e, TQWidget *widget );
    void loadItem( const TQDomElement &e, TQPixmap &pix, TQString &txt, bool &hasPixmap );
    void createItem( const TQDomElement &e, TQWidget *widget, TQListViewItem *i = 0 );
    void loadChildAction( TQObject *parent, const TQDomElement &e );
    void loadActions( const TQDomElement &e );
    void loadToolBars( const TQDomElement &e );
    void loadMenuBar( const TQDomElement &e );
    void loadPopupMenu( TQPopupMenu *p, const TQDomElement &e );
    void loadFunctions( const TQDomElement &e );
    TQAction *findAction( const TQString &name );
    void loadExtraSource();
    TQString translate( const char *sourceText, const char *comment = "" );
    TQString translate( const TQString& sourceText, const TQString& comment = TQString::null );

    void unpackUInt16( TQDataStream& in, Q_UINT16& n );
    void unpackUInt32( TQDataStream& in, Q_UINT32& n );
    void unpackByteArray( TQDataStream& in, TQByteArray& array );
    void unpackCString( const UibStrTable& strings, TQDataStream& in,
			TQCString& cstr );
    void unpackString( const UibStrTable& strings, TQDataStream& in,
		       TQString& str );
    void unpackStringSplit( const UibStrTable& strings, TQDataStream& in,
			    TQString& str );
    void unpackVariant( const UibStrTable& strings, TQDataStream& in,
			TQVariant& value );
    void inputSpacer( const UibStrTable& strings, TQDataStream& in,
		      TQLayout *parent );
    void inputColumnOrRow( const UibStrTable& strings, TQDataStream& in,
			   TQObject *parent, bool isRow );
    void inputItem( const UibStrTable& strings, TQDataStream& in,
		    TQObject *parent, TQListViewItem *parentItem = 0 );
    void inputMenuItem( TQObject **objects, const UibStrTable& strings,
			TQDataStream& in, TQMenuBar *menuBar );
    TQObject *inputObject( TQObject **objects, int& numObjects,
			  const UibStrTable& strings, TQDataStream& in,
			  TQWidget *ancestorWidget, TQObject *parent,
			  TQCString className = "" );
    TQWidget *createFromUiFile( TQDomDocument doc, TQObject *connector,
			       TQWidget *parent, const char *name );
    TQWidget *createFromUibFile( TQDataStream& in, TQObject *connector,
				TQWidget *parent, const char *name );

private:
    struct Image {
	TQImage img;
	TQString name;
	bool operator==(  const Image &i ) const {
	    return ( i.name == name &&
		     i.img == img );
	}
    };

    struct Field
    {
	Field() {}
	Field( const TQString &s1, const TQPixmap &p, const TQString &s2 ) : name( s1 ), pix( p ), field( s2 ) {}
	TQString name;
	TQPixmap pix;
	TQString field;
	Q_DUMMY_COMPARISON_OPERATOR( Field )
    };

    struct SqlWidgetConnection
    {
	SqlWidgetConnection() {}
	SqlWidgetConnection( const TQString &c, const TQString &t )
	    : conn( c ), table( t ), dbControls( new TQMap<TQString, TQString>() ) {}
	TQString conn;
	TQString table;
	TQMap<TQString, TQString> *dbControls;
	Q_DUMMY_COMPARISON_OPERATOR( SqlWidgetConnection )
    };

    TQValueList<Image> images;
    TQWidget *toplevel;
    QWidgetFactoryPrivate *d;
    TQMap<TQString, TQString> *dbControls;
    TQMap<TQString, TQStringList> dbTables;
    TQMap<TQWidget*, SqlWidgetConnection> sqlWidgetConnections;
    TQMap<TQString, TQString> buddies;
    TQMap<TQTable*, TQValueList<Field> > fieldMaps;
    TQPtrList<TQAction> actionList;
    TQMap<TQString, TQString> languageSlots;
    TQStringList noDatabaseWidgets;
    bool usePixmapCollection;
    int defMargin;
    int defSpacing;
    TQString code;
    TQString uiFileVersion;
};

#endif
