/**********************************************************************
** Copyright (C) 2000 Trolltech AS.  All rights reserved.
**
** This file is part of Qt Designer.
**
** This file may be distributed and/or modified under the terms of the
** GNU General Public License version 2 as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL included in the
** packaging of this file.
**
** Licensees holding valid Qt Enterprise Edition or Qt Professional Edition
** licenses may use this file in accordance with the Qt Commercial License
** Agreement provided with the Software.
**
** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
**
** See http://www.trolltech.com/gpl/ for GPL licensing information.
** See http://www.trolltech.com/pricing.html or email sales@trolltech.com for
**   information about Qt Commercial License Agreements.
**
** Contact info@trolltech.com if any conditions of this licensing are
** not clear to you.
**
**********************************************************************/

#ifndef DATABASE2_H
#define DATABASE2_H

#include "tqfeatures.h"

#ifndef QT_NO_SQL
#include <tqdataview.h>
#include <tqdatabrowser.h>
#include <tqsqlcursor.h>
#include <tqstring.h>

class TQSqlDatabase;
class TQSqlForm;

class DatabaseSupport2
{
public:
    DatabaseSupport2();
    virtual ~DatabaseSupport2() {}

    void initPreview( const TQString &connection, const TQString &table, TQObject *o,
		      const TQMap<TQString, TQString> &databaseControls );

protected:
    TQSqlDatabase* con;
    TQSqlForm* frm;
    TQString tbl;
    TQMap<TQString, TQString> dbControls;
    TQObject *parent;

};

class QDesignerDataBrowser2 : public TQDataBrowser, public DatabaseSupport2
{
    Q_OBJECT

public:
    QDesignerDataBrowser2( TQWidget *parent, const char *name );

protected:
    bool event( TQEvent* e );
};

class QDesignerDataView2 : public TQDataView, public DatabaseSupport2
{
    Q_OBJECT

public:
    QDesignerDataView2( TQWidget *parent, const char *name );

protected:
    bool event( TQEvent* e );

};

#define DatabaseSupport DatabaseSupport2
#define QDesignerDataBrowser QDesignerDataBrowser2
#define QDesignerDataView QDesignerDataView2

#endif

#endif
