/**********************************************************************
**
** Copyright (C) 2000 Trolltech AS.  All rights reserved.
**
** This file is part of Qt Designer.
**
** This file may be distributed and/or modified under the terms of the
** GNU General Public License version 2 as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL included in the
** packaging of this file.
**
** Licensees holding valid Qt Enterprise Edition or Qt Professional Edition
** licenses may use this file in accordance with the Qt Commercial License
** Agreement provided with the Software.
**
** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
**
** See http://www.trolltech.com/gpl/ for GPL licensing information.
** See http://www.trolltech.com/pricing.html or email sales@trolltech.com for
**   information about Qt Commercial License Agreements.
**
** Contact info@trolltech.com if any conditions of this licensing are
** not clear to you.
**
**********************************************************************/

#ifndef LANGUAGEINTERFACEIMPL_H
#define LANGUAGEINTERFACEIMPL_H

#include "../interfaces/languageinterface.h"

class LanguageInterfaceImpl : public LanguageInterface
{
public:
    LanguageInterfaceImpl( QUnknownInterface *outer = 0 );

    ulong addRef();
    ulong release();

    QRESULT queryInterface( const QUuid&, QUnknownInterface** );

    void functions( const TQString &code, TQValueList<Function> *funcs ) const;
    void connections( const TQString &, TQValueList<Connection> * ) const {};
    TQString createFunctionStart( const TQString &className, const TQString &func,
				 const TQString &returnType, const TQString &access );
    TQStringList definitions() const;
    TQStringList definitionEntries( const TQString &definition, QUnknownInterface *designerIface ) const;
    void setDefinitionEntries( const TQString &definition, const TQStringList &entries, QUnknownInterface *designerIface );
    TQString createArguments( const TQString & ) { return TQString::null; }
    TQString createEmptyFunction();
    bool supports( Support s ) const;
    TQStringList fileFilterList() const;
    TQStringList fileExtensionList() const;
    void preferedExtensions( TQMap<TQString, TQString> &extensionMap ) const;
    void sourceProjectKeys( TQStringList &keys ) const;
    TQString projectKeyForExtension( const TQString &extension ) const;
    TQString cleanSignature( const TQString &sig ) { return sig; } // #### implement me
    void loadFormCode( const TQString &, const TQString &,
		       TQValueList<Function> &,
		       TQStringList &,
		       TQValueList<Connection> & );
    TQString formCodeExtension() const { return ".h"; }
    bool canConnect( const TQString &signal, const TQString &slot );
    void compressProject( const TQString &, const TQString &, bool ) {}
    TQString uncompressProject( const TQString &, const TQString & ) { return TQString::null; }
    TQString aboutText() const { return ""; }

    void addConnection( const TQString &, const TQString &,
			const TQString &, const TQString &,
			TQString * ) {}
    void removeConnection( const TQString &, const TQString &,
			   const TQString &, const TQString &,
			   TQString * ) {}
    TQStrList signalNames( TQObject *obj ) const;

private:
    QUnknownInterface *parent;
    ulong ref;

};

#endif
