/**********************************************************************
** Copyright (C) 2000 Trolltech AS.  All rights reserved.
**
** This file is part of Qt Designer.
**
** This file may be distributed and/or modified under the terms of the
** GNU General Public License version 2 as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL included in the
** packaging of this file.
**
** Licensees holding valid Qt Enterprise Edition or Qt Professional Edition
** licenses may use this file in accordance with the Qt Commercial License
** Agreement provided with the Software.
**
** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
**
** See http://www.trolltech.com/gpl/ for GPL licensing information.
** See http://www.trolltech.com/pricing.html or email sales@trolltech.com for
**   information about Qt Commercial License Agreements.
**
** Contact info@trolltech.com if any conditions of this licensing are
** not clear to you.
**
**********************************************************************/

#ifndef MAINWINDOW_H
#define MAINWINDOW_H

#include "metadatabase.h"
#include "../interfaces/actioninterface.h" // for GCC 2.7.* compatibility
#include "../interfaces/editorinterface.h"
#include "../interfaces/templatewizardiface.h"
#include "../interfaces/languageinterface.h"
#include "../interfaces/filterinterface.h"
#include "../interfaces/interpreterinterface.h"
#include "../interfaces/preferenceinterface.h"
#include "../interfaces/projectsettingsiface.h"
#include "../interfaces/sourcetemplateiface.h"
#include "sourceeditor.h"

#include <tqaction.h>
#include <tqmainwindow.h>
#include <tqmap.h>
#include <tqguardedptr.h>
#include <private/qpluginmanager_p.h>
#include <tqobjectlist.h>

class TQToolBox;
class PropertyEditor;
class TQWorkspace;
class TQMenuBar;
class FormWindow;
class TQPopupMenu;
class HierarchyView;
class TQCloseEvent;
class Workspace;
class ActionEditor;
class Project;
class OutputWindow;
class TQTimer;
class FindDialog;
struct DesignerProject;
class ReplaceDialog;
class GotoLineDialog;
class SourceFile;
class FormFile;
class QAssistantClient;
class DesignerAction;

#if defined(Q_FULL_TEMPLATE_INSTANTIATION)
#include <tqtoolbar.h>
#else
class TQToolBar;
#endif
class Preferences;

class KDevDesignerPart;

class MainWindow : public QMainWindow
{
    Q_OBJECT

public:
    enum LineMode { Error, Step, StackFrame };

    MainWindow( KDevDesignerPart *part, bool asClient, bool single = FALSE, const TQString &plgDir = "/designer" );
    ~MainWindow();

    HierarchyView *objectHierarchy() const;
    Workspace *workspace() const;
    PropertyEditor *propertyeditor() const;
    ActionEditor *actioneditor() const;

    void resetTool();
    int currentTool() const;

    FormWindow *formWindow();

    bool unregisterClient( FormWindow *w );
    void editorClosed( SourceEditor *e );
    TQWidget *isAFormWindowChild( TQObject *o ) const;
    TQWidget *isAToolBarChild( TQObject *o ) const;

    void insertFormWindow( FormWindow *fw );
    TQWorkspace *qWorkspace() const;

    void popupFormWindowMenu( const TQPoint &gp, FormWindow *fw );
    void popupWidgetMenu( const TQPoint &gp, FormWindow *fw, TQWidget *w );

    TQPopupMenu *setupNormalHierarchyMenu( TQWidget *parent );
    TQPopupMenu *setupTabWidgetHierarchyMenu( TQWidget *parent, const char *addSlot, const char *removeSlot );

    FormWindow *openFormWindow( const TQString &fn, bool validFileName = TRUE, FormFile *ff = 0 );
    bool isCustomWidgetUsed( MetaDataBase::CustomWidget *w );

    void setGrid( const TQPoint &p );
    void setShowGrid( bool b );
    void setSnapGrid( bool b );
    TQPoint grid() const { return grd; }
    bool showGrid() const { return sGrid; }
    bool snapGrid() const { return snGrid && sGrid; }

    TQString documentationPath() const;

    static MainWindow *self;

    TQString templatePath() const { return templPath; }

    void editFunction( const TQString &func, bool rereadSource = FALSE );

    bool isPreviewing() const { return previewing; }

    Project *currProject() const { return currentProject; }

    FormWindow *activeForm() const { return lastActiveFormWindow; }

    TemplateWizardInterface* templateWizardInterface( const TQString& className );
    TQStringList sourceTemplates() const;
    SourceTemplateInterface* sourceTemplateInterface( const TQString& templ );
    QUnknownInterface* designerInterface() const { return desInterface; }
    TQPtrList<DesignerProject> projectList() const;
    TQStringList projectNames() const;
    TQStringList projectFileNames() const;
    Project *findProject( const TQString &projectName ) const;
    void setCurrentProject( Project *pro );
    void setCurrentProjectByFilename( const TQString& proFilename );
    OutputWindow *outputWindow() const { return oWindow; }
    void addPreferencesTab( TQWidget *tab, const TQString &title, TQObject *receiver, const char *init_slot, const char *accept_slot );
    void addProjectTab( TQWidget *tab, const TQString &title, TQObject *receiver, const char *init_slot, const char *accept_slot );
    void setModified( bool b, TQWidget *window );
    void functionsChanged();
    void updateFunctionList();
    void updateWorkspace();
    void runProjectPrecondition();
    void runProjectPostcondition( TQObjectList *l );

    void formNameChanged( FormWindow *fw );

    int currentLayoutDefaultSpacing() const;
    int currentLayoutDefaultMargin() const;

    void saveAllBreakPoints();
    void resetBreakPoints();

    SourceFile *sourceFile();
    void createNewProject( const TQString &lang );

    void popupProjectMenu( const TQPoint &pos );
    TQObject *findRealObject( TQObject *o );

    void setSingleProject( Project *pro );
    bool singleProjectMode() const { return singleProject; }

    void showSourceLine( TQObject *o, int line, LineMode lm );

    void shuttingDown();
    void showGUIStuff( bool b );
    void setEditorsReadOnly( bool b );
    bool areEditorsReadOnly() const { return editorsReadOnly; }
    void toggleSignalHandlers( bool show );
    bool showSignalHandlers() const { return sSignalHandlers; }
    void writeConfig();

    void openProject( const TQString &fn );
    void setPluginDirectory( const TQString &pd );
    TQString pluginDirectory() const { return pluginDir; }

    QAssistantClient* assistantClient() const { return assistant; }

    void addRecentlyOpenedFile( const TQString &fn ) { addRecentlyOpened( fn, recentlyFiles ); }

    void statusMessage(const TQString &msg);
    
    //integration
    KDevDesignerPart *part() const { return m_part; }
    
public slots:
    void showProperties( TQObject *w );
    void updateProperties( TQObject *w );
    void showDialogHelp();
    void showDebugStep( TQObject *o, int line );
    void showStackFrame( TQObject *o, int line );
    void showErrorMessage( TQObject *o, int line, const TQString &errorMessage );
    void finishedRun();
    void breakPointsChanged();

signals:
    void currentToolChanged();
    void hasActiveForm( bool );
    void hasActiveWindow( bool );
    void hasActiveWindowOrProject( bool );
    void hasNonDummyProject( bool );
    void formModified( bool );
    void formWindowsChanged();
    void formWindowChanged();
    void projectChanged();
    void editorChanged();

protected:
    bool eventFilter( TQObject *o, TQEvent *e );
    void closeEvent( TQCloseEvent *e );

public slots:
    void fileNew();
    void fileNewDialog();
    void fileNewFile();
    void fileClose();
    void fileQuit();
    void fileCloseProject(); // not visible in menu, called from fileClose
    void fileOpen();
    void fileOpen( const TQString &filter, const TQString &extension, const TQString &filename = "" , bool inProject = TRUE );
    bool fileSave();
    bool fileSaveForm(); // not visible in menu, called from fileSave
    bool fileSaveProject(); // not visible in menu, called from fileSaveProject
    bool fileSaveAs();
    void fileSaveAll();
    void fileCreateTemplate();

public slots:
    void editUndo();
    void editRedo();
    void editCut();
    void editCopy();
    void editPaste();
    void editDelete();
    void editSelectAll();
    void editLower();
    void editRaise();
    void editAdjustSize();
    void editLayoutHorizontal();
    void editLayoutVertical();
    void editLayoutHorizontalSplit();
    void editLayoutVerticalSplit();
    void editLayoutGrid();
    void editLayoutContainerHorizontal();
    void editLayoutContainerVertical();
    void editLayoutContainerGrid();
    void editBreakLayout();
    void editAccels();
    void editFunctions();
    void editConnections();
    SourceEditor *editSource();
    SourceEditor *editSource( SourceFile *f );
    SourceEditor *openSourceEditor();
    SourceEditor *createSourceEditor( TQObject *object, Project *project,
				      const TQString &lang = TQString::null,
				      const TQString &func = TQString::null,
				      bool rereadSource = FALSE );
    void editFormSettings();
    void editProjectSettings();
    void editPixmapCollection();
    void editDatabaseConnections();
    void editPreferences();

    void projectInsertFile();

    void searchFind();
    void searchIncremetalFindMenu();
    void searchIncremetalFind();
    void searchIncremetalFindNext();
    void searchReplace();
    void searchGotoLine();

    void previewForm();
    void previewForm( const TQString& );

    void toolsCustomWidget();
    void toolsConfigure();

    void helpContents();
    void helpManual();
    void helpAbout();
    void helpAboutQt();
    void helpRegister();

private slots:
    void activeWindowChanged( TQWidget *w );
    void updateUndoRedo( bool, bool, const TQString &, const TQString & );
    void updateEditorUndoRedo();

    void toolSelected( TQAction* );

    void clipboardChanged();
    void selectionChanged();

    void windowsMenuActivated( int id );
    void setupWindowActions();

    void createNewTemplate();
    void projectSelected( TQAction *a );

    void setupRecentlyFilesMenu();
    void setupRecentlyProjectsMenu();
    void recentlyFilesMenuActivated( int id );
    void recentlyProjectsMenuActivated( int id );

    void emitProjectSignals();

    void showStartDialog();

private:
    void setupMDI();
    void setupMenuBar();
    void setupEditActions();
    void setupProjectActions();
    void setupSearchActions();
    void setupToolActions();
    void setupLayoutActions();
    void setupFileActions();
    void setupPreviewActions();
    void setupHelpActions();
    void setupRMBMenus();

    void setupPropertyEditor();
    void setupHierarchyView();
    void setupWorkspace();
    void setupActionEditor();
    void setupOutputWindow();
    void setupToolbox();

    void setupActionManager();
    void setupPluginManagers();

    void enableAll( bool enable );

    TQWidget* previewFormInternal( TQStyle* style = 0, TQPalette* pal = 0 );

    void readConfig();

    void setupRMBProperties( TQValueList<uint> &ids, TQMap<TQString, int> &props, TQWidget *w );
    void handleRMBProperties( int id, TQMap<TQString, int> &props, TQWidget *w );
    void setupRMBSpecialCommands( TQValueList<uint> &ids, TQMap<TQString, int> &commands, TQWidget *w );
    void handleRMBSpecialCommands( int id, TQMap<TQString, int> &commands, TQWidget *w );
    void setupRMBSpecialCommands( TQValueList<uint> &ids, TQMap<TQString, int> &commands, FormWindow *w );
    void handleRMBSpecialCommands( int id, TQMap<TQString, int> &commands, FormWindow *w );
    bool openEditor( TQWidget *w, FormWindow *fw );
    void rebuildCustomWidgetGUI();
    void rebuildCommonWidgetsToolBoxPage();
    void checkTempFiles();

    void addRecentlyOpened( const TQString &fn, TQStringList &lst );

    TQString whatsThisFrom( const TQString &key );

private slots:
    void doFunctionsChanged();
    bool openProjectSettings( Project *pro );

private:
    struct Tab
    {
	TQWidget *w;
	TQString title;
	TQObject *receiver;
	const char *init_slot, *accept_slot;
	Q_DUMMY_COMPARISON_OPERATOR( Tab )
    };

private:
    PropertyEditor *propertyEditor;
    HierarchyView *hierarchyView;
    Workspace *wspace;
    TQWidget *lastPressWidget;
    TQWorkspace *qworkspace;
    TQMenuBar *menubar;
    TQGuardedPtr<FormWindow> lastActiveFormWindow;
    bool breakLayout, layoutChilds, layoutSelected;
    TQPoint grd;
    bool sGrid, snGrid;
    bool restoreConfig;
    bool backPix;
    bool splashScreen;
    TQString fileFilter;

    TQMap<TQAction*, Project*> projects;
    DesignerAction *actionEditUndo, *actionEditRedo, *actionEditCut, *actionEditCopy,
    *actionEditPaste, *actionEditDelete,
    *actionEditAdjustSize,
    *actionEditHLayout, *actionEditVLayout, *actionEditGridLayout,
    *actionEditSplitHorizontal, *actionEditSplitVertical,
    *actionEditSelectAll, *actionEditBreakLayout, *actionEditFunctions, *actionEditConnections,
    *actionEditLower, *actionEditRaise;
    TQAction *actionInsertSpacer;
    TQActionGroup *actionGroupTools, *actionGroupProjects;
    TQAction* actionPointerTool, *actionConnectTool, *actionOrderTool, *actionBuddyTool;
    TQAction* actionCurrentTool;
    DesignerAction *actionHelpContents, *actionHelpAbout, *actionHelpAboutQt, *actionHelpWhatsThis;
    DesignerAction *actionHelpManual;
#if defined(QT_NON_COMMERCIAL)
    DesignerAction *actionHelpRegister;
#endif
    DesignerAction *actionToolsCustomWidget, *actionEditPreferences;
    DesignerAction *actionWindowTile, *actionWindowCascade, *actionWindowClose, *actionWindowCloseAll;
    DesignerAction *actionWindowNext, *actionWindowPrevious;
    DesignerAction *actionEditFormSettings, *actionEditAccels;
    DesignerAction *actionEditSource, *actionNewFile, *actionFileSave, *actionFileExit;
    DesignerAction *actionFileClose, *actionFileSaveAs, *actionFileSaveAll;
    DesignerAction *actionSearchFind, *actionSearchIncremetal, *actionSearchReplace, *actionSearchGotoLine;
    DesignerAction *actionProjectAddFile, *actionEditPixmapCollection, *actionEditDatabaseConnections,
        *actionEditProjectSettings, *actionPreview;
    TQActionGroup *actionGroupNew;

    TQPopupMenu *rmbWidgets;
    TQPopupMenu *rmbFormWindow;
    TQPopupMenu *customWidgetMenu, *windowMenu, *fileMenu, *recentlyFilesMenu, *recentlyProjectsMenu;
    TQPopupMenu *toolsMenu, *layoutMenu, *previewMenu;
    TQToolBar *customWidgetToolBar, *layoutToolBar, *projectToolBar, *customWidgetToolBar2, *toolsToolBar;
    TQToolBar *commonWidgetsToolBar;
    TQPtrList<TQToolBar> widgetToolBars;

    Preferences *prefDia;
    TQMap<TQString,TQString> propertyDocumentation;
    bool client;
    TQString templPath;
    ActionEditor *actionEditor;
    Project *currentProject;
    QPluginManager<ActionInterface> *actionPluginManager;
    QPluginManager<EditorInterface> *editorPluginManager;
    QPluginManager<TemplateWizardInterface> *templateWizardPluginManager;
    QPluginManager<InterpreterInterface> *interpreterPluginManager;
    QPluginManager<PreferenceInterface> *preferencePluginManager;
    QPluginManager<ProjectSettingsInterface> *projectSettingsPluginManager;
    QPluginManager<SourceTemplateInterface> *sourceTemplatePluginManager;
    TQPtrList<SourceEditor> sourceEditors;
    bool previewing;
    QUnknownInterface *desInterface;
    TQStringList recentlyFiles;
    TQStringList recentlyProjects;
    OutputWindow *oWindow;
    TQValueList<Tab> preferenceTabs;
    TQValueList<Tab> projectTabs;
    bool databaseAutoEdit;
    TQTimer *updateFunctionsTimer;
    TQTimer *autoSaveTimer;
    bool autoSaveEnabled;
    int autoSaveInterval;
    TQLineEdit *incrementalSearch;
    TQGuardedPtr<FindDialog> findDialog;
    TQGuardedPtr<ReplaceDialog> replaceDialog;
    TQGuardedPtr<GotoLineDialog> gotoLineDialog;
    Project *eProject;
    bool inDebugMode;
    TQObjectList debuggingForms;
    TQString lastOpenFilter;
    TQGuardedPtr<TQWidget> previewedForm;
    TQPopupMenu *projectMenu;
    TQString menuHelpFile;
    bool singleProject;
    TQToolBox *toolBox;
    int toolsMenuId, toolsMenuIndex;
    uint guiStuffVisible : 1;
    uint editorsReadOnly : 1;
    uint savePluginPaths : 1;
    QAssistantClient *assistant;
    bool shStartDialog;
    TQString pluginDir;
    bool sSignalHandlers;
    
    KDevDesignerPart *m_part;

public:
    TQString lastSaveFilter;
    TQPtrList<TQAction> toolActions;
    TQPtrList<TQAction> commonWidgetsPage;

friend class KDevDesignerPart;
};

class SenderObject : public QObject
{
    Q_OBJECT

public:
    SenderObject( QUnknownInterface *i ) : iface( i ) { iface->addRef(); }
    ~SenderObject() { iface->release(); }

public slots:
    void emitInitSignal() { emit initSignal( iface ); }
    void emitAcceptSignal() { emit acceptSignal( iface ); }

signals:
    void initSignal( QUnknownInterface * );
    void acceptSignal( QUnknownInterface * );

private:
    QUnknownInterface *iface;

};

#endif
