/***************************************************************************
 *   Copyright (C) 2004 by Alexander Dymo                                  *
 *   cloudtemple@mksat.net                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.             *
 ***************************************************************************/

#ifndef _KDEVDESIGNERPART_H_
#define _KDEVDESIGNERPART_H_

#include <tqmap.h>

#include <kparts/part.h>
#include <kparts/factory.h>

#include "designer.h"

class TQWidget;
class TQPainter;
class KURL;
class MainWindow;
class KAction;
class TQAction;
class KRadioAction;

class KDevDesignerPart : public KInterfaceDesigner::Designer
{
    Q_OBJECT
public:
    KDevDesignerPart(TQWidget *parentWidget, const char *widgetName,
                    TQObject *parent, const char *name, const TQStringList &args);
    virtual ~KDevDesignerPart();

    virtual void setReadWrite(bool rw);
    virtual void setModified(bool modified);
    
    void statusMessage(const TQString &msg);

    //KInterfaceDesigner::Designer methods
    virtual void openProject(const TQString &projectFile);
    virtual KInterfaceDesigner::DesignerType designerType();

    void emitAddedFunction(const TQString &form, KInterfaceDesigner::Function func);
    void emitEditedFunction(const TQString &form, KInterfaceDesigner::Function oldFunc, KInterfaceDesigner::Function func);
    void emitRemovedFunction(const TQString &form, KInterfaceDesigner::Function func);

    void emitEditFunction(const TQString &formName, const TQString &functionName);
    void emitEditSource(const TQString &formName);
    
    void emitNewStatus(const TQString &formName, int status);
    
protected:
    virtual bool openFile();
    virtual bool saveFile();
    
    void setupDesignerWindow();
    void setupActions();
    
    void stateSync(KAction *kaction, TQAction *qaction);
    void setupToolsAction(KRadioAction *toggle, TQAction *action);

protected slots:
    void setToggleActionChecked(bool b);
    void setToggleActionOn(bool b);
    
    void fileNew();
    void fileOpen();
    void fileClose();
    void fileSaveAs();
    void fileCreateTemplate();
    
    void editUndo();
    void editRedo();
    void editCut();
    void editCopy();
    void editPaste();
    void editDelete();
    void editSelectAll();
    void editAccels();
    void editFunctions();
    void editConnections();
    void editFormSettings();
    void editPreferences();
    
    void projectAddFile();
    void projectImageCollection();
    void projectDatabaseCollections();
    void projectSettings();
    
    void toolsConfigureToolbox();
    void toolsEditCustomWidgets();
    
    void layoutAdjustSize();
    void layoutHLayout();
    void layoutVLayout();
    void layoutGridLayout();
    void layoutSplitHLayout();
    void layoutSplitVLayout();
    void layoutBreak();
    
    void windowPreview();
    void windowNext();
    void windowPrev();
    
    void formModified(bool b);
private:
    MainWindow *m_widget;
    
    TQMap<const TQAction*, KRadioAction*> m_actionMap;
    TQMap<const KRadioAction*, TQAction*> m_actionMap2;
    KRadioAction* pointerAction;
};

class KInstance;
class KAboutData;

class KDevDesignerPartFactory : public KParts::Factory
{
    Q_OBJECT
public:
    KDevDesignerPartFactory();
    virtual ~KDevDesignerPartFactory();
    virtual KParts::Part* createPartObject( TQWidget *parentWidget, const char *widgetName,
                                            TQObject *parent, const char *name,
                                            const char *classname, const TQStringList &args );
    static KInstance* instance();
 
private:
    static KInstance* s_instance;
    static KAboutData* s_about;
};

#endif // _KDEVDESIGNERPART_H_
