/***************************************************************************
 *   Copyright (C) 2004 by Alexander Dymo                                  *
 *   cloudtemple@mksat.net                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.             *
 ***************************************************************************/
#ifndef DESIGNERACTION_H
#define DESIGNERACTION_H

#include <tqaction.h>

class DesignerAction : public QAction
{
Q_OBJECT
public:
    DesignerAction(TQObject *parent = 0, const char *name = 0)
            :TQAction(parent, name) {}
    DesignerAction ( const TQString & menuText, TQKeySequence accel, TQObject * parent, const char * name = 0 )
            :TQAction(menuText, accel, parent, name) {}
    DesignerAction ( const TQIconSet & icon, const TQString & menuText, TQKeySequence accel, TQObject * parent, const char * name = 0 )
            :TQAction(icon, menuText, accel, parent, name) {}
    DesignerAction ( const TQString & text, const TQIconSet & icon, const TQString & menuText, TQKeySequence accel, TQObject * parent, const char * name = 0, bool toggle = FALSE ) 
            :TQAction(text, icon, menuText, accel, parent, name, toggle) {}
    DesignerAction ( const TQString & text, const TQString & menuText, TQKeySequence accel, TQObject * parent, const char * name = 0, bool toggle = FALSE )
            :TQAction(text, menuText, accel, parent, name, toggle) {}
    DesignerAction ( TQObject * parent, const char * name, bool toggle ) 
            :TQAction(parent, name, toggle) {}
    ~DesignerAction();
    
    virtual void setEnabled(bool e);
    virtual void setDisabled(bool d);
#if QT_VERSION < 0x030300
    virtual void activate();
#endif

signals:
    void actionEnabled(bool e);
    
};

#endif
