/**********************************************************************
** Copyright (C) 2000 Trolltech AS.  All rights reserved.
**
** This file is part of Qt Designer.
**
** This file may be distributed and/or modified under the terms of the
** GNU General Public License version 2 as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL included in the
** packaging of this file.
**
** Licensees holding valid Qt Enterprise Edition or Qt Professional Edition
** licenses may use this file in accordance with the Qt Commercial License
** Agreement provided with the Software.
**
** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
**
** See http://www.trolltech.com/gpl/ for GPL licensing information.
** See http://www.trolltech.com/pricing.html or email sales@trolltech.com for
**   information about Qt Commercial License Agreements.
**
** Contact info@trolltech.com if any conditions of this licensing are
** not clear to you.
**
**********************************************************************/

#ifndef CUSTOMWIDGETEDITORIMPL_H
#define CUSTOMWIDGETEDITORIMPL_H

#include "customwidgeteditor.h"
#include "metadatabase.h"

#include <tqmap.h>
#include <tqobjectlist.h>

class TQTimer;
class TQListBoxItem;
class MainWindow;

class CustomWidgetEditor : public CustomWidgetEditorBase
{
    Q_OBJECT

public:
    CustomWidgetEditor( TQWidget *parent , MainWindow *mw);

protected slots:
    void addWidgetClicked();
    void classNameChanged( const TQString & );
    void currentWidgetChanged( TQListBoxItem * );
    void deleteWidgetClicked();
    void headerFileChanged( const TQString & );
    void heightChanged( int );
    void includePolicyChanged( int );
    void pixmapChoosen();
    void widthChanged( int );
    void chooseHeader();
    void checkWidgetName();
    void closeClicked();
    void currentSignalChanged( TQListBoxItem *i );
    void addSignal();
    void removeSignal();
    void signalNameChanged( const TQString &s );
    void slotAccessChanged( const TQString & );
    void slotNameChanged( const TQString & );
    void addSlot();
    void removeSlot();
    void currentSlotChanged( TQListViewItem * );
    void propertyTypeChanged( const TQString & );
    void propertyNameChanged( const TQString & );
    void addProperty();
    void removeProperty();
    void currentPropertyChanged( TQListViewItem * );
    void saveDescription();
    void loadDescription();
    void horDataChanged( int );
    void verDataChanged( int );
    void widgetIsContainer( bool );
    
private:
    MetaDataBase::CustomWidget *findWidget( TQListBoxItem *i );
    void setupDefinition();
    void setupSignals();
    void setupSlots();
    void setupProperties();
    void updateCustomWidgetSizes();

private:
    TQMap<TQListBoxItem*, MetaDataBase::CustomWidget*> customWidgets;
    TQString oldName;
    TQTimer *checkTimer;
    TQListBoxItem *oldItem;
    MainWindow *mainWindow;
    TQObjectList cwLst;

};

#endif
