/**********************************************************************
** Copyright (C) 2000-2002 Trolltech AS.  All rights reserved.
**
** This file is part of Qt Designer.
**
** This file may be distributed and/or modified under the terms of the
** GNU General Public License version 2 as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL included in the
** packaging of this file.
**
** Licensees holding valid Qt Enterprise Edition or Qt Professional Edition
** licenses may use this file in accordance with the Qt Commercial License
** Agreement provided with the Software.
**
** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
**
** See http://www.trolltech.com/gpl/ for GPL licensing information.
** See http://www.trolltech.com/pricing.html or email sales@trolltech.com for
**   information about Qt Commercial License Agreements.
**
** Contact info@trolltech.com if any conditions of this licensing are
** not clear to you.
**
**********************************************************************/

#ifndef ACTIONDND_H
#define ACTIONDND_H

#include <tqaction.h>
#include <tqdragobject.h>
#include <tqmap.h>
#include <tqmenubar.h>
#include <tqpixmap.h>
#include <tqpopupmenu.h>
#include <tqptrlist.h>
#include <tqtoolbar.h>
#include <tqguardedptr.h>
#include "../shared/widgetdatabase.h"

//class QDesignerPopupMenu;
class QDesignerIndicatorWidget;
class FormWindow;
class TQPopupMenu;

class QDesignerIndicatorWidget : public QWidget
{
    Q_OBJECT

public:
    QDesignerIndicatorWidget( TQWidget *p )
	: TQWidget( p, "qt_dockwidget_internal" ) {
	    setBackgroundColor( red );
    }

};

class ActionDrag : public QStoredDrag
{
    Q_OBJECT

public:
    ActionDrag(const TQString &type, TQAction *action, TQWidget *source);
    ActionDrag(TQAction *action, TQWidget *source);
    ActionDrag(TQActionGroup *group, TQWidget *source);

    ~ActionDrag();

    static bool canDecode(TQDropEvent *e);

    static TQAction *action()
    {
	return the_action;
    }

private:
    static TQAction *the_action;
};

class QDesignerActionGroup : public QActionGroup
{
    Q_OBJECT

public:
    QDesignerActionGroup( TQObject *parent )
	: TQActionGroup( ::qt_cast<TQActionGroup*>(parent) ? parent : 0 ), wid( 0 ), idx( -1 ) { init(); }

    void init();

    TQWidget *widget() const { return wid; }
    TQWidget *widget( TQAction *a ) const { return *widgets.find( a ); }
    int index() const { return idx; }

protected:
#if !defined(Q_NO_USING_KEYWORD)
    using TQActionGroup::addedTo;
#endif
    void addedTo( TQWidget *w, TQWidget * ) {
	wid = w;
    }
    void addedTo( TQWidget *w, TQWidget *, TQAction *a ) {
	widgets.insert( a, w );
    }
    void addedTo( int index, TQPopupMenu * ) {
	idx = index;
    }

private:
    TQWidget *wid;
    TQMap<TQAction *, TQWidget *> widgets;
    int idx;

};

class QDesignerAction : public QAction
{
    Q_OBJECT

public:
    QDesignerAction( TQObject *parent )
	: TQAction( ::qt_cast<TQActionGroup*>(parent) ? parent : 0 ), wid( 0 ), idx( -1 ), widgetToInsert( 0 ) { init(); }
    QDesignerAction( TQWidget *w, TQObject *parent )
	: TQAction( ::qt_cast<TQActionGroup*>(parent) ? parent : 0 ), wid( 0 ), idx( -1 ), widgetToInsert( w ) { init(); }

    void init();

    TQWidget *widget() const { return wid; }
    int index() const { return idx; }

    bool addTo( TQWidget *w );
    bool removeFrom( TQWidget *w );

    void remove();
    bool supportsMenu() const { return !widgetToInsert; }

protected:
    void addedTo( TQWidget *w, TQWidget * ) {
	wid = w;
    }
    void addedTo( int index, TQPopupMenu * ) {
	idx = index;
    }

private:
    TQWidget *wid;
    int idx;
    TQWidget *widgetToInsert;

};

class QDesignerToolBarSeparator : public QWidget
{
    Q_OBJECT

public:
    QDesignerToolBarSeparator( Orientation, TQToolBar *parent, const char* name=0 );

    TQSize sizeHint() const;
    Orientation orientation() const { return orient; }
public slots:
   void setOrientation( Orientation );
protected:
    void styleChange( TQStyle& );
    void paintEvent( TQPaintEvent * );
private:
    Orientation orient;
};


class QSeparatorAction : public QAction
{
    Q_OBJECT

public:
    QSeparatorAction( TQObject *parent );

    bool addTo( TQWidget *w );
    bool removeFrom( TQWidget *w );
    TQWidget *widget() const;
    int index() const;

private:
    TQWidget *wid;
    int idx;

};


class QDesignerToolBar : public QToolBar
{
    Q_OBJECT

public:
    QDesignerToolBar( TQMainWindow *mw );
    QDesignerToolBar( TQMainWindow *mw, Dock dock );
    TQPtrList<TQAction> insertedActions() const { return actionList; }
    void addAction( TQAction *a );

    void clear();
    void installEventFilters( TQWidget *w );
    void insertAction( TQWidget *w, TQAction *a ) { actionMap.insert( w, a ); }
    void insertAction( int index, TQAction *a ) { actionList.insert( index, a ); }
    void appendAction( TQAction *a ) { actionList.append( a ); }
    void removeAction( TQAction *a ) { actionList.remove( a ); }
    void reInsert();
    void removeWidget( TQWidget *w );

protected:
    bool eventFilter( TQObject *, TQEvent * );
    void paintEvent( TQPaintEvent * );
#ifndef QT_NO_DRAGANDDROP
    void dragEnterEvent( TQDragEnterEvent * );
    void dragMoveEvent( TQDragMoveEvent * );
    void dragLeaveEvent( TQDragLeaveEvent * );
    void dropEvent( TQDropEvent * );
#endif
    void contextMenuEvent( TQContextMenuEvent *e );
    void mousePressEvent( TQMouseEvent *e );
    void mouseReleaseEvent( TQMouseEvent *e );

private slots:
    void actionRemoved();

private:
    void drawIndicator( const TQPoint &pos );
    TQPoint calcIndicatorPos( const TQPoint &pos );
    void buttonContextMenuEvent( TQContextMenuEvent *e, TQObject *o );
    void buttonMousePressEvent( TQMouseEvent *e, TQObject *o );
    void buttonMouseMoveEvent( TQMouseEvent *e, TQObject *o );
    void buttonMouseReleaseEvent( TQMouseEvent *e, TQObject *o );
    void doInsertWidget( const TQPoint &p );
    void findFormWindow();

private:
    TQPoint lastIndicatorPos;
    TQWidget *insertAnchor;
    bool afterAnchor;
    TQPtrList<TQAction> actionList;
    TQMap<TQWidget*, TQAction*> actionMap;
    TQPoint dragStartPos;
    QDesignerIndicatorWidget *indicator;
    bool widgetInserting;
    FormWindow *formWindow;

};

#endif
