/***************************************************************************
*   Copyright (C) 2006 by Andreas Pakulat                                 *
*   apaku@gmx.de                                                          *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
*                                                                         *
***************************************************************************/

#ifndef _QMAKESCOPEITEM_H_
#define _QMAKESCOPEITEM_H_

#include <tqlistview.h>
#include <tqstring.h>

class Scope;
class QMakeScopeItem;
class FileItem;
class TrollProjectWidget;

/**
 * Base class for all items appearing in ProjectOverview and ProjectDetails.
 */
class qProjectItem : public QListViewItem
{
public:
    enum Type { Subproject, Group, File };

    qProjectItem( Type type, TQListView *parent, const TQString &text );
    qProjectItem( Type type, qProjectItem *parent, const TQString &text );

    TQString scopeString;
    Type type()
    { return typ; }

private:
    Type typ;
    void init();

};


class GroupItem : public qProjectItem
{
public:
    enum GroupType {NoType, Sources, Headers, Forms, Distfiles, Images, Resources, Lexsources, Yaccsources, Translations, IDLs, InstallRoot, InstallObject, MaxTypeEnum };

    static GroupType groupTypeForExtension( const TQString &ext );
    static void groupTypeMeanings( GroupItem::GroupType type, TQString& title, TQString& ext );

    GroupItem( TQListView *lv, GroupType type, const TQString &text, QMakeScopeItem* spitem );

    void removeFileFromScope( const TQString& filename);
    void addFileToScope( const TQString& filename);
    void addInstallObject( const TQString& objectname);
    void removeInstallObject( GroupItem* item );

    // qmake INSTALLS support
    TQPtrList<GroupItem> installs;
    TQPtrList<FileItem> files;

//     TQStringList str_files;
//     TQStringList str_files_exclude;
    // end qmake INSTALLS support
    GroupType groupType;
    QMakeScopeItem* owner;

protected:
    void paintCell( TQPainter* p, const TQColorGroup& cg, int column, int width, int align );
};


// Not sure if this complexity is really necessary...
class FileItem : public qProjectItem
{
public:
    FileItem( TQListView *lv, const TQString &text );

    TQString uiFileLink;
    TQString localFilePath;
};

/**
 * Stores one Scope
 */
class QMakeScopeItem : public qProjectItem
{
public:
    QMakeScopeItem( TQListView *parent, const TQString &text, Scope *s, TrollProjectWidget* widget );
    QMakeScopeItem( QMakeScopeItem *parent, const TQString &text, Scope* );
    void updateValues( const TQString& var, const TQStringList& values );
    void addValue( const TQString& var, const TQString& value );
    void removeValue( const TQString& var, const TQString& value );
    void addValues( const TQString& var, const TQStringList& values );
    void removeValues( const TQString& var, const TQStringList& values );
    void disableSubprojects( const TQStringList& );
    void reloadProject();
    int compare( TQListViewItem* i, int col, bool ascending ) const;
    ~QMakeScopeItem();

    TQMap<GroupItem::GroupType, GroupItem*> groups;

    Scope* scope;
    TQString relativePath();
    TQString getLibAddPath( TQString );
    TQString getLibAddObject( TQString );
    TQString getSharedLibAddObject( TQString );
    TQString getApplicationObject( TQString );
    TQString getIncAddPath( TQString downDirs );
    FileItem* createFileItem(const TQString& file);
    GroupItem* createGroupItem(GroupItem::GroupType type, const TQString& name, QMakeScopeItem* scopeitem);
    TQMap<TQString, TQString> getLibInfos( TQString );

    QMakeScopeItem* projectFileItem();

    TrollProjectWidget* m_widget;
private:
    void init();
    void buildSubTree();
    void buildGroups();
};


#endif

// kate: space-indent on; indent-width 4; tab-width 4; replace-tabs on
