/***************************************************************************
 *   Copyright (C) 2001-2002 by Bernd Gehrmann                             *
 *   bernd@kdevelop.org                                                    *
 *   Copyright (C) 2007 by Andreas Pakulat                                 *
 *   apaku@gmx.de                                                          *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef _CUSTOMPROJECTPART_H_
#define _CUSTOMPROJECTPART_H_

#include <tqdict.h>
#include <tqguardedptr.h>
#include <tqmap.h>
#include <tqdatetime.h>
#include <tqvaluestack.h>

#include <kdevbuildtool.h>

class TQListViewItem;
class TQPopupMenu;
class TQStringList;
class KDialogBase;
class CustomProjectWidget;
class Context;
class KSelectAction;

class CustomProjectPart : public KDevBuildTool
{
    Q_OBJECT

public:
    CustomProjectPart( TQObject *parent, const char *name, const TQStringList & );
    ~CustomProjectPart();

    TQStringList allMakeEnvironments() const;
    TQString currentMakeEnvironment() const;

    bool isDirty();
    TQStringList distFiles() const;

    virtual void openProject( const TQString &dirName, const TQString &projectName );
    virtual void closeProject();

    virtual TQString projectDirectory() const;
    virtual TQString projectName() const;
    virtual TQString mainProgram() const;
    virtual TQString activeDirectory() const;
    virtual TQStringList allFiles() const;
    virtual void addFile( const TQString &fileName );
    virtual void addFiles( const TQStringList& fileList );
    virtual void removeFile( const TQString &fileName );
    virtual void removeFiles( const TQStringList &fileList );
    virtual TQString buildDirectory() const;
    virtual TQString runDirectory() const;
    virtual TQString debugArguments() const;
    virtual TQString runArguments() const;
    virtual DomUtil::PairList runEnvironmentVars() const;
    TQString relativeToProject( const TQString& ) const;


private slots:
    void populateProject();
    void projectConfigWidget( KDialogBase *dlg );
    void contextMenu( TQPopupMenu *popup, const Context *context );
    void slotAddToProject();
    void slotRemoveFromProject();
    void slotAddToProjectRecursive();
    void slotRemoveFromProjectRecursive();
    void addNewFilesToProject( const TQStringList& );
    void slotChangeBlacklist();
    void slotChooseActiveDirectory();
    void slotBuild();
    void slotBuildActiveDir();
    void slotCompileFile();
    void slotInstall();
    void slotInstallActiveDir();
    void slotInstallWithKdesu();
    void slotClean();
    void slotExecute();
    void updateTargetMenu();
    void targetMenuActivated( int id );
    void targetObjectFilesMenuActivated( int id );
    void targetOtherFilesMenuActivated( int id );
    void updateMakeEnvironmentsMenu();
    void makeEnvironmentsMenuActivated( int id );
    void slotCommandFinished( const TQString& command );
    void slotCommandFailed( const TQString& command );

private:
    bool containsNonProjectFiles( const TQString& url );
    TQStringList projectFilesInDir( const TQString& dir );
    bool containsProjectFiles( const TQString& url );
    bool isProjectFileType( const TQString& absFile ) const;
    bool isInBlacklist( const TQString& ) const;
    void cleanFileList();
    void setFiletypes( const TQStringList& );
    void findNewFiles( const TQString& dir, TQStringList& list) const;

    TQStringList filetypes() const;
    TQStringList blacklist() const;
    void updateBlacklist( const TQStringList& );
    void saveProject();
    void startMakeCommand( const TQString &dir, const TQString &target, bool withKdesu = false );
    void parseMakefile( const TQString& file );
    TQString makeEnvironment() const;
    void putEnvVarsInVarMap();
    void switchBlacklistEntry(const TQString& );

    bool isInProject( const TQString& fileName ) const;
    void addToProject( const TQString& fileName );
    void removeFromProject( const TQString& fileName );

    /**
     * @brief Set of all the project's files.
     *
     * @bug
     * Due to deficiency in QT3,
     * we have to use a map with next-to-useless element value,
     * keyed by the file name,
     * as a set-container replacement.
     */
    typedef TQMap<TQString, bool> ProjectFilesSet;

    TQString m_projectDirectory;
    TQString m_projectName;
    TQString m_filelistDir;
    /** All the sources (files and directories) of this project. */
    ProjectFilesSet m_sourceFilesSet;
    TQPopupMenu *m_targetMenu;
    TQPopupMenu *m_targetObjectFilesMenu;
    TQPopupMenu *m_targetOtherFilesMenu;
    KSelectAction *m_makeEnvironmentsSelector;
    TQStringList m_targets;
    TQStringList m_targetsObjectFiles;
    TQStringList m_targetsOtherFiles;
    TQStringList m_contextAddFiles;
    TQStringList m_contextRemoveFiles;
    TQString m_contextDirName;

    TQMap<TQString, TQDateTime> m_timestamp;
    bool m_executeAfterBuild;
    TQString m_buildCommand;
    bool m_lastCompilationFailed;
    TQMap<TQString, int> m_parsedMakefiles;
    TQValueStack<TQString> m_makefilesToParse;
    TQMap<TQString, TQString> m_makefileVars;
    bool m_recursive;
    bool m_first_recursive;
};

#endif
// kate: space-indent on; indent-width 4; tab-width 4; replace-tabs on
