/***************************************************************************
*   Copyright (C) 2001-2002 by Bernd Gehrmann                             *
*   bernd@kdevelop.org                                                    *
*                                                                         *
*   Copyright (C) 2002 by Victor Rï¿½er                                    *
*   victor_roeder@gmx.de                                                  *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
*                                                                         *
***************************************************************************/

#ifndef _AUTOPROJECTPART_H_
#define _AUTOPROJECTPART_H_

#include <tqdict.h>
#include <tqguardedptr.h>
#include <tqmap.h>
#include <tqdatetime.h>
#include <tqdir.h>
#include <kdevgenericfactory.h>
#include "kdevbuildtool.h"

class TQDomElement;
class TQStringList;
class KDialogBase;
class AutoProjectWidget;
class KSelectAction;
class TargetItem;
class ConfigWidgetProxy;

class AutoProjectPart : public KDevBuildTool
{
	Q_OBJECT

public:
	AutoProjectPart( TQObject *parent, const char *name, const TQStringList &args );
	virtual ~AutoProjectPart();

	/**
	 * Implementation of the KDevProject interface.
	 */
	virtual TQString projectDirectory() const;
	virtual TQString projectName() const;
	virtual DomUtil::PairList runEnvironmentVars() const;
	virtual TQString runDirectory() const;
	virtual TQString mainProgram() const;
	virtual TQString debugArguments() const;
	virtual TQString runArguments() const;
	virtual TQString environString() const;
	virtual TQString activeDirectory() const;
	virtual TQStringList allFiles() const;
	virtual void addFile( const TQString &fileName );
	virtual void addFiles ( const TQStringList& fileList );
	virtual void removeFile( const TQString &fileName );
	virtual void removeFiles ( const TQStringList& fileList );
	virtual TQString buildDirectory() const;
	virtual Options options() const;

	/**
	 * Implementation of the KDevPlugin interface.
	 */
	virtual void restorePartialProjectSession ( const TQDomElement* el );
	virtual void savePartialProjectSession ( TQDomElement* el );

	/**
	 * automake specific methods.
	 */
	TQStringList allBuildConfigs() const;
	TQString currentBuildConfig() const;
	TQString topsourceDirectory() const;
	void startMakeCommand( const TQString &dir, const TQString &target, bool withKdesu = false );
	void startSimpleMakeCommand( const TQString &dir, const TQString &command, bool withKdesu = false );
	void buildTarget( TQString relpath, TargetItem* titem );
	void executeTarget( const TQDir& dir, const TargetItem* titem );

	void needMakefileCvs();
	bool isDirty();
	bool isKDE() const;
	TQStringList distFiles() const;
	TQString getAutoConfFile(const TQString& dir);

protected:
	/**
	 * Reimplemented from KDevProject. These methods are only
	 * for use by the application core.
	 */
	virtual void openProject( const TQString &dirName, const TQString &projectName );
	virtual void closeProject();

private slots:
	//    void projectConfigWidget(KDialogBase *dlg);
	void slotAddTranslation();
	void slotBuild();
	void slotBuildActiveTarget();
	void slotCompileFile();
	void slotClean();
	void slotDistClean();
	void slotInstall();
	void slotInstallWithKdesu();
	void slotMakefilecvs();
	void slotMakeMessages();
	void slotConfigure();
	void slotExecute();
	void slotExecute2();
	void slotExecuteTargetAfterBuild( const TQString& command );
	void slotNotExecuteTargetAfterBuildFailed( const TQString& command );
	void slotBuildConfigChanged( const TQString &config );
	void slotBuildConfigAboutToShow();
	void slotCommandFinished( const TQString& command );
	void slotCommandFailed( const TQString& command );
	//void slotImportExisting();
	void insertConfigWidget( const KDialogBase* dlg, TQWidget * page, unsigned int );


private:
	TQGuardedPtr<AutoProjectWidget> m_widget;
	TQString m_projectName;
	TQString m_projectPath;
	KSelectAction *buildConfigAction;

	TQString makeEnvironment() const;
	void setWantautotools();
	TQString makefileCvsCommand() const;
	TQString configureCommand() const;

	TQMap<TQString, TQDateTime> m_timestamp;
	bool m_executeAfterBuild;
	TQString m_buildCommand;
	bool m_needMakefileCvs;
	bool m_lastCompilationFailed;
	bool m_isKDE;
	QPair<TQDir, TargetItem*> m_executeTargetAfterBuild;
	TQString m_runProg;

	ConfigWidgetProxy * _configProxy;

	// Enble AutoProjectWidget to emit our signals
	friend class AutoProjectWidget;
	friend class AddSubprojectDialog;
	friend class FileItem;

	// For make commands queuing
	TQString constructMakeCommandLine( const TQString &dir, const TQString &target ) const;
	bool queueInternalLibDependenciesBuild( TargetItem* titem, TQStringList& list );
};

typedef KDevGenericFactory<AutoProjectPart> AutoProjectFactory;

#endif
// kate: indent-mode csands; tab-width 4;
