/* This file is part of the KDE project
   Copyright (C) 2001 Holger Freyther <freyther@yahoo.com>

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public
   License as published by the Free Software Foundation; version 2
   of the License.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; see the file COPYING.  If not, write to
   the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
   Boston, MA 02110-1301, USA.
*/

//#include "image_plugin.moc"

#include <kdebug.h>
#include <kgenericfactory.h>
#include <kiconloader.h>
#include <renamedlgplugin.h>
#include <kio/renamedlg.h>
#include <tqlabel.h>
#include <tqdialog.h>
#include <tqwidget.h>
#include <tqstringlist.h>
#include <kio/global.h>
#include <tqlayout.h>

#include <sys/types.h>

#include "imagevisualizer.h"

class ImagePlugin : public RenameDlgPlugin{
public:
  ImagePlugin( TQDialog *dialog, const char *name, const TQStringList & );
  virtual bool initialize( KIO::RenameDlg_Mode /*mod*/, const TQString &/*_src*/, const TQString &/*_dest*/,
		  const TQString &/*mimeSrc*/,
		  const TQString &/*mimeDest*/,
		  KIO::filesize_t /*sizeSrc*/,
		  KIO::filesize_t /*sizeDest*/,
		  time_t /*ctimeSrc*/,
		  time_t /*ctimeDest*/,
		  time_t /*mtimeSrc*/,
		  time_t /*mtimeDest*/ );
};

ImagePlugin::ImagePlugin( TQDialog *dialog, const char *name, const TQStringList &list ) 
  : RenameDlgPlugin( dialog, name, list) 
{
}

bool ImagePlugin::initialize( KIO::RenameDlg_Mode mode, const TQString &_src, const TQString &_dest,
		  const TQString &/*mimeSrc*/,
		  const TQString &/*mimeDest*/,
		  KIO::filesize_t /*sizeSrc*/,
		  KIO::filesize_t /*sizeDest*/,
		  time_t /*ctimeSrc*/,
		  time_t /*ctimeDest*/,
		  time_t /*mtimeSrc*/,
		  time_t /*mtimeDest*/ ) 
{
  TQGridLayout *lay = new TQGridLayout(this, 2, 3, 5  );
  if( mode & KIO::M_OVERWRITE )
  {
    TQLabel *label = new TQLabel(this );
    label->setText(i18n("You want to overwrite the left picture with the one on the right.") );
    label->adjustSize();
    lay->addMultiCellWidget(label, 1, 1, 0, 2,  Qt::AlignHCenter  );
    adjustSize();
  }
  ImageVisualizer *left= new ImageVisualizer(this, "Visualizer Left", _dest );
  ImageVisualizer *right = new ImageVisualizer( this, "Visualizer Right", _src );
  lay->addWidget(left, 2, 0 );
  lay->addWidget(right, 2, 2 );
  adjustSize();
  return true;
}

typedef KGenericFactory<ImagePlugin, TQDialog> ImagePluginFactory;
K_EXPORT_COMPONENT_FACTORY( librenimageplugin, ImagePluginFactory("imagerename_plugin") )
