// Copyright (c) 2003 Charles Samuels <charles@kde.org>
// See the file COPYING for redistribution terms.

#ifndef MENU_H
#define MENU_H

#include <kpopupmenu.h>
#include <kpropertiesdialog.h>
#include <kaction.h>

#include "file.h"
#include "oblique.h"

/**
 * a context menu for a item in the list
 **/
class FileMenu : public KPopupMenu
{
Q_OBJECT
	TQValueList<File> mFiles;

public:
	FileMenu(TQWidget *parent, Oblique *oblique, File file);
	/**
	 * @recursively uses everything under @p files
	 **/
	FileMenu(TQWidget *parent, Oblique *oblique, TreeItem *files);

private slots:
	void removeFromList();
	void properties();
	void toggleInSlice(Slice *slice);
};

class SliceListAction : public KActionMenu
{
Q_OBJECT
	TQMap<int, Slice*> mIndexToSlices;
	TQValueList<File> mFiles;
	Oblique *mOblique;

public:
	SliceListAction(
			const TQString &text, Oblique *oblique,
			TQObject *reciever, const char *slot,
			const TQValueList<File> &files = TQValueList<File>(), TQObject *parent=0, const char *name=0
		);

signals:
	void activated(Slice *slice);

private slots:
	void hit(int index);
	void slicesModified();
};


class SchemaListAction : public KActionMenu
{
Q_OBJECT
	TQMap<int, TQString> mIndexToSchemas;
	Tree *mTree;

public:
	SchemaListAction(
			const TQString &text,
			TQObject *reciever, const char *slot,
			TQObject *parent, const char *name
		);

	void setTree(Tree *tree) { mTree = tree; }

signals:
	void activated(const TQString &);

private slots:
	void hit(int index);
	void prepare();
};


class ObliquePropertiesDialog : public KPropertiesDialog
{
Q_OBJECT
	TQValueList<File> mFiles;

public:
	ObliquePropertiesDialog(const TQValueList<File> &files, TQWidget *parent);

private:
	static KFileItemList makeItems(const TQValueList<File> &files);

private slots:
	void modified();
};


#endif

