#ifndef _LYRICSCMODULE_H_
#define _LYRICSCMODULE_H_

#include <noatun/pref.h>
#include <tqvaluevector.h>
#include <klocale.h>

class KLineEdit;
class KListBox;
class KButtonBox;

struct SearchProvider {
  TQString name;
  TQString url;
};

class LyricsCModule : public CModule {
  Q_OBJECT
  public:
    LyricsCModule(TQObject *_parent);
  public slots:
    virtual void save(void);
    virtual void reopen(void);
    void newSearch(TQString name = i18n( "New Search Provider" ), TQString query = "");
    void delSearch();
    void moveUpSearch();
    void moveDownSearch();
    void selected( TQListBoxItem *i );
    void nameChanged( const TQString &name );
    void queryChanged( const TQString &query );
  protected:
    KListBox *providersBox;
    KButtonBox *boxButtons;
    KLineEdit *nameEdit;
    KLineEdit *queryEdit;
    TQValueVector<SearchProvider> mProviders;
};





#endif
