/***************************************************************************
                 wakeup.h  -  alarm plugin for noatun
                     -------------------
     begin    : Wed Apr 11 CEST 2000
     copyright: (C) 2001 by Mickael Marchand <mikmak@freenux.org>
                                                       
 ***************************************************************************/
/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/


#ifndef WAKEUP_H
#define WAKEUP_H

#include <noatun/pref.h>
#include <noatun/plugin.h>
#include <tqradiobutton.h>
#include <tqbuttongroup.h>
#include <tqpushbutton.h>

class TQSpinBox;
class TQCheckBox;
class KMinuteSpinBox;
class KPercentSpinBox;

class Wakeup : public TQObject, public Plugin
{
	Q_OBJECT
	NOATUNPLUGIND

public:
	Wakeup();
	~Wakeup();
	static Wakeup *wakeme;
	void PlayerAct();
	void update();

public slots:
	void slotVolumeChange(); 
	void slotCheckTime();
	
private:
	TQStringList *day_list;
//	TQString songlist;
	int hour[7];
	int minute[7];
	bool days[7];
	TQTimer *volTimer;
	int volEndVal;
	int modeAlarm;
};


class WakeupPrefs : public CModule
{
	Q_OBJECT

public:
	WakeupPrefs( TQObject *parent );
	virtual void save();
	virtual void load();
public slots:
	void slotViewFrame(int);
	void slotApplyAll();

private:
	TQCheckBox *monday;
	TQCheckBox *tuesday;
	TQCheckBox *wednesday;
	TQCheckBox *thursday;
	TQCheckBox *friday;
	TQCheckBox *saturday;
	TQCheckBox *sunday;
	KMinuteSpinBox *minute1;
	KMinuteSpinBox *minute2;
	KMinuteSpinBox *minute3;
	KMinuteSpinBox *minute4;
	KMinuteSpinBox *minute5;
	KMinuteSpinBox *minute6;
	KMinuteSpinBox *minute7;
	TQSpinBox *hour1;
	TQSpinBox *hour2;
	TQSpinBox *hour3;
	TQSpinBox *hour4;
	TQSpinBox *hour5;
	TQSpinBox *hour6;
	TQSpinBox *hour7;

	KPercentSpinBox *volEndValue;
	TQRadioButton *alarmmode;
	TQRadioButton *morningmode;
	TQRadioButton *nightmode;
	TQFrame *volFrame;
	TQPushButton *applyall;
};

#endif // WAKEUP_H
