/***************************************************************************
                          siggenerator.cpp  -  description
                             -------------------
    begin                : Sat Jul 20 2002
    copyright            : (C) 2002 by Scott Wheeler
    email                : wheeler@kde.org
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "siggenerator.h"
#include "siglistviewitem.h"

#include <kstandarddirs.h>
#include <kapplication.h>
#include <kconfig.h>
#include <kdebug.h>

#include <tqfile.h>
#include <tqdatetime.h>

SigGenerator::SigGenerator()
{
    TQString dir = KGlobal::dirs()->saveLocation("appdata");
    TQFile file(dir + "sigs.sigml");

    if(file.open(IO_ReadOnly) && doc.setContent(&file)) {
	signatures = doc.elementsByTagName("signature");
	file.close();
    }

    KConfig *config = KGlobal::config();
    {
	KConfigGroupSaver saver(config, "Settings");
	header = config->readEntry("Header");
	footer = config->readEntry("Footer");
    }
}

SigGenerator::~SigGenerator()
{

}


TQString SigGenerator::random() const
{
    if(signatures.count() <= 0)
	return(TQString::null);

    int i = KApplication::random() % signatures.count();
    TQString text;
    SigListViewItem::nodeToText(signatures.item(i), text);
    
    return attachStandard(text);
}

TQString SigGenerator::daily() const
{
    if(signatures.count() <= 0)
	return(TQString::null);

    TQDate date;
    int i = date.dayOfYear() % signatures.count();
    TQString text;
    SigListViewItem::nodeToText(signatures.item(i), text);
    return attachStandard(text);
}

TQString SigGenerator::attachStandard(const TQString &text) const
{
    TQString s = text;

    if(!header.isEmpty())
	s = header + "\n" + s;
    if(!footer.isEmpty())
	s = s + "\n" + footer + "\n";

    return s;
}
