/*
   Copyright (C) 2003 Antonio Larrosa <larrosa@kde.org>

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; see the file COPYING.  If not, write to
   the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
   Boston, MA 02110-1301, USA.
*/

#ifndef _ARCHIVEDIALOG_H_
#define _ARCHIVEDIALOG_H_

#include <dom/dom_core.h>
#include <dom/html_document.h>

#include <kdialogbase.h>
#include <ktempfile.h>
#include <kio/job.h>

#include <tqstring.h>
#include <tqmap.h>
#include <tqvaluelist.h>

class TQWidget;
class KHTMLPart;
class ArchiveViewBase;
class KURL;
class KTar;
class TQTextStream;
class TQListViewItem;

class ArchiveDialog : public KDialogBase
{
   Q_OBJECT
public:
   ArchiveDialog(TQWidget *parent, const TQString &targetFilename, KHTMLPart *part);
   ~ArchiveDialog();

   void archive();

public slots:
   void finishedDownloadingURL( KIO::Job *job );
   void setSavingState();
protected:
   void saveFile( const TQString& fileName);
   void saveToArchive(TQTextStream* _textStream);
   void saveArchiveRecursive(const DOM::Node &node, const KURL& baseURL,
                             TQTextStream* _textStream, int ident);
   TQString handleLink(const KURL& _url, const TQString & _link);
   KURL getAbsoluteURL(const KURL& _url, const TQString& _link);
   TQString getUniqueFileName(const TQString& fileName);
   TQString stringToHTML(const TQString& string);
   TQString analyzeInternalCSS(const KURL& _url, const TQString& string);
   void downloadNext();

   ArchiveViewBase *m_widget;
   TQMap<TQString, TQString> m_downloadedURLDict;
   TQMap<TQString, TQString> m_linkDict;
   KTar* m_tarBall;
   bool m_bPreserveWS;
   TQListViewItem *m_currentLVI;
   unsigned int m_iterator;
   enum State { Retrieving=0, Downloading, Saving };
   State m_state;
   TQValueList <KURL>m_urlsToDownload;
   KTempFile *m_tmpFile;
   KURL m_url;
   DOM::Document m_document;
   
};

#endif // _ARCHIVEDIALOG_H_
