//////////////////////////////////////////////////////////////////////////
// tagListItem.cpp                                                      //
//                                                                      //
// Copyright (C)  2005  Lukas Tinkl <lukas@kde.org>                     //
//                                                                      //
// This program is free software; you can redistribute it and/or        //
// modify it under the terms of the GNU General Public License          //
// as published by the Free Software Foundation; either version 2       //
// of the License, or (at your option) any later version.               //
//                                                                      //
// This program is distributed in the hope that it will be useful,      //
// but WITHOUT ANY WARRANTY; without even the implied warranty of       //
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        //
// GNU General Public License for more details.                         //
//                                                                      //
// You should have received a copy of the GNU General Public License    //
// along with this program; if not, write to the Free Software          //
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA            //
// 02110-1301, USA.                                                     //
//////////////////////////////////////////////////////////////////////////

#include "tagListItem.h"

TagListItem::TagListItem( TQListView * parent, const TQString & tagName, int count )
    : TQCheckListItem( parent, tagName, TQCheckListItem::CheckBox ), m_name( tagName ), m_count( count )
{
}

// virtual
void TagListItem::stateChange( bool state )
{
    TQCheckListItem::stateChange( state );
    emit signalItemChecked( this );
}

// virtual
int TagListItem::compare( TQListViewItem * i, int col, bool ascending ) const
{
    if ( col == 1 )
    {
        int them = static_cast<TagListItem *>( i )->count();
        if ( m_count < them )
            return -1;
        else if ( m_count > them )
            return 1;
        else
            return 0;
    }
    return TQCheckListItem::compare( i, col, ascending );
}

int TagListItem::count() const
{
    return m_count;
}

// virtual
TQString TagListItem::text( int column ) const
{
    if ( column == 0 )
        return m_name;
    else if ( column == 1 )
        return TQString::number( m_count );
    else
        return TQString::null;
}

TQString TagListItem::name() const
{
    return m_name;
}

void TagListItem::setName( const TQString & name )
{
    m_name = name;
}

#include "tagListItem.moc"
