// -*- mode: c++; c-basic-offset: 4 -*-
/*
  Copyright (C) 2006 Daniele Galdi <daniele.galdi@gmail.com>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
*/

#ifndef KONQ_ADBLOCKDLG_H
#define KONQ_ADBLOCKDLG_H

#include <kdialogbase.h>
#include <tqlistview.h>

class TQLabel;
class TQLineEdit;
class KPopupMenu;

class AdBlockDlg : public KDialogBase
{
    Q_OBJECT
    
private:
    TQLineEdit *m_filter;
    TQListView *m_list;
    TQLabel *m_label1;
    TQLabel *m_label2;
    KPopupMenu *m_menu;

public:
    AdBlockDlg(TQWidget *parent, AdElementList &elements);
    ~AdBlockDlg();

private slots:
    void validateFilter ();
    void updateFilter(TQListViewItem *item);
    void showContextMenu(TQListViewItem *item, const TQPoint &point);
    void filterPath();
    void filterItem();

signals:
    void notEmptyFilter (const TQString &url);
};

// ----------------------------------------------------------------------------

class ListViewItem : public QListViewItem
{
private:
    bool m_blocked;

public:
    ListViewItem(TQListView *listView, 
		 const TQString &label1, 
		 const TQString &label2, 
		 const TQString &label3) : TQListViewItem(listView, label1, label2, label3), 
					  m_blocked(false){};

    void paintCell(TQPainter *p, const TQColorGroup & cg, int column, int width, int align);

    bool isBlocked();
    void setBlocked(bool blocked);
};

#endif
